import cv2
import numpy as np

import cv2
import numpy as np

# Load the image
image_path = 'test_data/binary_masks_step_10_threshhold_80/224_kite.png'  # Replace with your image path
image = cv2.imread(image_path, cv2.IMREAD_GRAYSCALE)

# Check if the image was loaded successfully
if image is None:
    raise ValueError("Image not found or unable to load.")
#upper half of the image
ca = image[:image.shape[0]//2, :]
binary_image = image[image.shape[0]//2:, :]

# Apply connectedComponents
num_labels, labels = cv2.connectedComponents(binary_image, connectivity=4)
output_mask = np.zeros(binary_image.shape, dtype=np.uint8)

for label in range(1, num_labels):  # Skip background (label 0)
    component = (labels == label).astype(np.uint8)
    if np.sum(component) >= 1000:
        output_mask[labels == label] = 255

# Output results
print("Number of labels:", num_labels)
print("Labels array:\n", labels)

# save the output mask as a image
output_mask_path = 'reduced_mask.png'
cv2.imwrite("cross.png",ca)
cv2.imwrite("binary.png",binary_image)
cv2.imwrite(output_mask_path, output_mask)




