import argparse

def parse_args():
    parser = argparse.ArgumentParser()
    
    # Dataset
    parser.add_argument('--dataset', type=str, default='CiteSeer',
                        help='Dataset Name')
    parser.add_argument('--imb_ratio', type=float, default=10,
                        help='Imbalance Ratio')
    # Architecture
    parser.add_argument('--net', type=str, default='GCN',
                        help='Architecture name')
    parser.add_argument('--n_layer', type=int, default=2,
                        help='the number of layers')
    parser.add_argument('--feat_dim', type=int, default=256,
                        help='Feature dimension')
    # Imbalance Loss
    parser.add_argument('--loss_type', type=str, default='bs',
                        help='Loss type')
    # Method
    parser.add_argument('--tam', action='store_true',
                        help='use tam')
    parser.add_argument('--reweight', action='store_true',
                        help='use reweight')
    parser.add_argument('--pc_softmax', action='store_true',
                        help='use pc softmax')
    parser.add_argument('--ens', action='store_true',
                        help='use GraphENS')
    parser.add_argument('--renode', action='store_true',
                        help='use ReNode')
    # Hyperparameter for GraphENS
    parser.add_argument('--keep_prob', type=float, default=0.01,
                        help='Keeping Probability')
    parser.add_argument('--pred_temp', type=float, default=2,
                        help='Prediction temperature')             
    # ReNode
    parser.add_argument('--loss_name', default="re-weight", type=str, help="the training loss") #ce focal re-weight cb-softmax
    parser.add_argument('--factor_focal', default=2.0,    type=float, help="alpha in Focal Loss")
    parser.add_argument('--factor_cb',    default=0.9999, type=float, help="beta  in CB Loss")
    parser.add_argument('--rn_base',    default=0.5, type=float, help="Lower bound of RN")
    parser.add_argument('--rn_max',    default=1.5, type=float, help="Upper bound of RN")

    # Hyperparameter for TAM
    parser.add_argument('--tam_alpha', type=float, default=2.5,
                        help='coefficient of ACM')
    parser.add_argument('--tam_beta', type=float, default=0.5,
                        help='coefficient of ADM')
    parser.add_argument('--temp_phi', type=float, default=1.2,
                        help='classwise temperature')
    parser.add_argument('--warmup', type=int, default=5,
                        help='warmup')
    
    parser.add_argument('--regularizer',type=str, default=None,choices=['kl','kl_reverse'])
    parser.add_argument('--reg_coef',nargs=2,type=float, default = [0.1,1])
    parser.add_argument('--kl_power',nargs=2,type=float, default = [0.1,2])
    parser.add_argument('--num_trial',type=int, default = 40)
    parser.add_argument('--device',type=str, default='cuda:0')
    parser.add_argument('--run_type',type=str, default='')
    parser.add_argument('--repeatition',type=int, default = 10)
    parser.add_argument('--seed', type=int, default=42)
    parser.add_argument('--nhid', type=int, default=64)
    parser.add_argument('--lr', type=float, default=0.001)
    parser.add_argument('--size', type=int, default=100)
    parser.add_argument('--weight_decay', type=float, default=5e-4)
    parser.add_argument('--dropout', type=float, default=0.1)
    parser.add_argument('--batch_nums', type=int, default=6000, help='number of batches per epoch')
    parser.add_argument('--batch_size', type=int, default=40, help='number of batches per epoch')
    parser.add_argument('--setting', type=str, default='no', 
        choices=['no','upsampling', 'smote','reweight','embed_up', 'recon','newG_cls','recon_newG'])
    #upsampling: oversample in the raw input; smote: ; reweight: reweight minority classes; 
    # embed_up: 
    # recon: pretrain; newG_cls: pretrained decoder; recon_newG: also finetune the decoder
    parser.add_argument('--opt_new_G', action='store_true', default=False) # whether optimize the decoded graph based on classification result.
    parser.add_argument('--load', type=str, default=None)
    parser.add_argument('--up_scale', type=float, default=1)
    parser.add_argument('--im_ratio', type=float, default=0.5)
    parser.add_argument('--rec_weight', type=float, default=0.000001)
    parser.add_argument('--model', type=str, default='sage', 
        choices=['sage','gcn','GAT'])
    
    args = parser.parse_args()

    return args

