import json

from lita.core.tools import Tool


class Action:
    def __init__(self, tools: list[Tool] | None = None):
        self.tools = tools
        self.tool_map = {tool.name: tool for tool in tools}

    def execute(self, name: str, arguments: str, **kwargs) -> str:
        tool = self.tool_map.get(name, None)
        if not tool:
            return f"No such tool '{name}'."
        try:
            arguments = json.loads(arguments)
        except json.JSONDecodeError:
            return f"Invalid arguments for tool '{name}'."

        try:
            properties = tool.parameters.get("properties", {})
            for key in arguments:
                if key not in properties:
                    return f"Argument '{key}' is not allowed in the '{name}' tool."

            required = tool.parameters.get("required", [])
            for key in required:
                if key not in arguments:
                    return f"Missing required argument '{key}' for tool '{name}'."

            return tool(**arguments)
        except Exception as e:
            return str(e)
