from lita.core.agent.agent_base import AgentBase
from lita.core.terminal.terminal_local import LocalTerminal
from lita.core.terminal.terminal_local_docker import DockerTerminal

from .bash import ExecuteBash
from .finish import Finish
from .str_replace_editor import CAStrReplaceEditor
from .think import Think

from .prompt import system_prompt

class CodeActAgent(AgentBase):
    def __init__(
        self,
        run_id: str,
        model: str,
        verbose: bool = False,
        debug: bool = False,
        **kwargs,
    ):
        workdir = kwargs.get("work_dir", "")
        terminal: LocalTerminal | DockerTerminal = kwargs.get("terminal", LocalTerminal(workdir=workdir))

        SHORT_TOOL_DESCRIPTION_LLM_SUBSTRS = ['gpt-4', 'o3', 'o1', 'o4']
        use_short_tool_desc = any(model_substr in model for model_substr in SHORT_TOOL_DESCRIPTION_LLM_SUBSTRS)

        # For default tool choosing, please see:
        # openhands/core/config/agent_config.py: L14
        # system prompt:
        # openhands/agenthub/codeact_agent/prompts/system_prompt.j2
        super().__init__(
            model=model,
            system=system_prompt,
            tools=[
                ExecuteBash(use_short_tool_desc=use_short_tool_desc, terminal=terminal),
                CAStrReplaceEditor(use_short_tool_desc=use_short_tool_desc),
                Think(),
                Finish(),
            ],
            run_id=run_id,
            verbose=verbose,
            debug=debug,
            **kwargs,
        )
