from .tools import CodeActTool

_FINISH_DESCRIPTION = """Signals the completion of the current task or conversation.

Use this tool when:
- You have successfully completed the user's requested task
- You cannot proceed further due to technical limitations or missing information

The message should include:
- A clear summary of actions taken and their results
- Any next steps for the user
- Explanation if you're unable to complete the task
- Any follow-up questions if more information is needed
"""


class Finish(CodeActTool):
    name: str = "finish"
    description: str = _FINISH_DESCRIPTION
    parameters: dict = {
        'type': 'object',
        'required': ['message'],
        'properties': {
            'message': {
                'type': 'string',
                'description': 'Final message to send to the user',
            },
        },
    }

    def execute(self, message: str) -> str:
        return "STOP THE RUN HERE."
