from lita.core.agent.agent_base import AgentBase
from lita.core.agent.lite_agent.plan import Planning
from lita.core.agent.lite_agent.tools import (
    Finish,
    Search,
    TerminalBash,
    TextFileEditor,
    TextFileStrReplaceEditor,
    Think,
)
from lita.core.summarization import MemorySummarize
from lita.core.terminal.terminal_local import LocalTerminal
from lita.core.terminal.terminal_local_docker import DockerTerminal


class LiteAgent(AgentBase):
    def __init__(
        self,
        run_id: str,
        model: str,
        verbose: bool = False,
        debug: bool = False,
        terminal: LocalTerminal | DockerTerminal = None,
        **kwargs,
    ):
        if terminal is None:
            workdir = kwargs.get("work_dir", "")
            terminal = LocalTerminal(workdir=workdir)
        super().__init__(
            model=model,
            system="You are a powerful AI agent.",
            tools=[
                Planning(),
                Search(),
                TerminalBash(terminal=terminal),
                TextFileEditor(),
                Think(),
                Finish(),
            ],
            run_id=run_id,
            verbose=verbose,
            debug=debug,
            **kwargs,
        )


class LiteAgentWithSummarize(AgentBase):
    def __init__(
        self,
        run_id: str,
        model: str,
        verbose: bool = False,
        debug: bool = False,
        terminal: LocalTerminal | DockerTerminal = None,
        **kwargs,
    ):
        if terminal is None:
            workdir = kwargs.get("work_dir", "")
            terminal = LocalTerminal(workdir=workdir)
        super().__init__(
            model=model,
            system="You are a powerful AI agent.",
            tools=[
                Planning(),
                Search(),
                TerminalBash(terminal=terminal),
                TextFileEditor(),
                Think(),
                Finish(),
                MemorySummarize(),
            ],
            run_id=run_id,
            verbose=verbose,
            debug=debug,
            **kwargs,
        )


class LiteAgentSR(AgentBase):
    def __init__(
        self,
        run_id: str,
        model: str,
        verbose: bool = False,
        debug: bool = False,
        terminal: LocalTerminal | DockerTerminal = None,
        **kwargs,
    ):
        if terminal is None:
            workdir = kwargs.get("work_dir", "")
            terminal = LocalTerminal(workdir=workdir)
        super().__init__(
            model=model,
            system="You are a powerful AI agent.",
            tools=[
                Planning(),
                Search(),
                TerminalBash(terminal=terminal),
                TextFileStrReplaceEditor(),
                Think(),
                Finish(),
            ],
            run_id=run_id,
            verbose=verbose,
            debug=debug,
            **kwargs,
        )


class LiteAgentReason(AgentBase):
    def __init__(
        self,
        run_id: str,
        model: str,
        verbose: bool = False,
        debug: bool = False,
        terminal: LocalTerminal | DockerTerminal = None,
        **kwargs,
    ):
        if terminal is None:
            workdir = kwargs.get("work_dir", "")
            terminal = LocalTerminal(workdir=workdir)
        super().__init__(
            model=model,
            system="You are a powerful AI agent.",
            tools=[
                TerminalBash(terminal=terminal),
                Planning(),
                Think(),
            ],
            run_id=run_id,
            verbose=verbose,
            debug=debug,
            **kwargs,
        )


class LiteAgentTerminalOnly(AgentBase):
    def __init__(
        self,
        run_id: str,
        model: str,
        verbose: bool = False,
        debug: bool = False,
        terminal: LocalTerminal | DockerTerminal = None,
        **kwargs,
    ):
        if terminal is None:
            workdir = kwargs.get("work_dir", "")
            terminal = LocalTerminal(workdir=workdir)
        super().__init__(
            model=model,
            system="You are a powerful AI agent capable of interacting with a computer terminal to solve tasks.",
            tools=[
                TerminalBash(terminal=terminal),
            ],
            run_id=run_id,
            verbose=verbose,
            debug=debug,
            **kwargs,
        )
