import os

from lita.core.tools import Tool


class MemorySummarize(Tool):
    name: str = "summarize"
    description: str = (
        "Summarize the current task progress when the history context is too long or when you need to focus on key information. "
        "The summary content gives a concise overview to support better decisions and task completion. "
        "After summarization, the history assistant and tool messages will be cleared, only keep the system and user messages in the head."
    )
    parameters: dict = {
        "type": "object",
        "properties": {
            "content": {
                "description": "The summary content.",
                "type": "string",
            },
        },
        "required": ["content"],
    }

    def execute(self, **kwargs) -> str:
        return "Summarized the context and reset the memory."
