import subprocess


class Terminal:
    def __init__(self):
        self.workdir = None
        # If any, set by subclass
        self.env = None

    def execute(self, command: str, workdir=None, timeout=180) -> str:
        """Execute a command in the terminal. Capture all errors and return."""

        try:
            result = subprocess.run(
                command,
                shell=True,
                text=True,
                cwd=workdir,
                env=self.env,
                check=True,
                timeout=timeout,
                encoding="utf-8",
                errors="replace",
                stdout=subprocess.PIPE,
                stderr=subprocess.STDOUT,  # stderr will be merged into stdout
            )
            # Only those executed successfully with return code 0 will reach here?
            info = f"Command return code: {result.returncode}\nCommand output:\n{result.stdout}"
            return info
        except subprocess.CalledProcessError as e:
            # Test case failed
            # NOTE: merge stdout and stderr sequentially may cause problems?
            info = f"Command return code: {e.returncode}\nCommand output:\n{e.stdout}\n{e.stderr}"
            return info
        except subprocess.TimeoutExpired as e:
            return f"Command timed out after {e.timeout} seconds. Please try again."
        except Exception as e:
            return f"An unexpected error occurred: {str(e)}"
