import os

from .terminal import Terminal


class LocalTerminal(Terminal):
    workdir: str = None

    def __init__(self, **kwargs):
        self.env = os.environ | kwargs.get("env", {})
        python_env = kwargs.get("python_env")
        if python_env:
            # e.g. ".venv/bin"
            self.env["PATH"] = f"{python_env}:{self.env['PATH']}"

        workdir = kwargs.get("workdir")
        if workdir:
            self.workdir = workdir
        else:
            self.workdir = os.getcwd()

    def execute(self, command: str, workdir: str = "", timeout=180) -> dict:
        workdir = workdir or self.workdir
        result = super().execute(command, workdir=workdir, timeout=timeout)
        return result
