# Efficient Out-Of-Distribution Detection Via CVAE Data Generation

This is a PyTorch implementation for paper *Efficient Out-Of-Distribution Detection Via CVAE Data Generation*. Both two frameworks, CGA-softmax and CGA-energy, are supported in this code base.

## 1. Requirements

### Environments

The required packages are as follows:

- python 3.5
- torch 1.2
- torchvision 0.4
- CUDA 10.0
- scikit-learn 0.22

### Datasets

Please download datasets to `./datasets` and rename the file. All the benchmark datasets can be easily found online. For more details, please see `./datasets/datasetsHelper.py` and our paper.

## 2. CGA Stage 1

CGA Stage 1 involves IND classifier building and CVAE training.

The standard code is running with a single GPU and you can assign a specific GPU in the command line.

For more details, please view `utils.py`

### Train IND classifier

 To train IND classifier on MNIST, run this command:

```shell
python -m train --task='same_dataset_mnist' --partition='partitio
n1' --command='train_classifier' --device='cuda:0' --params-dict-name='./ckpt/main_model_partition1.pkl'
```

To train IND classifier on CIFAR10, run this command:

```shell
python -m train --task='same_dataset_cifar10' --partition='partitio
n1' --command='train_classifier' --device='cuda:0' --params-dict-name='./ckpt/main_model_partition1.pkl'
```

> --partition='partition1'/'partition2'/'partition3'/'partition4'/'partition5'; --params-dict-name={checkpoint name}; --device={the available GPU in your cluster}; you can change the seed by setting --seed={your seed}

### Train CVAE

To train CVAE on MNIST, run this command:

```shell
python -m train --task='same_dataset_mnist' --partition='partitio
n1' --command='train_cvae' --device='cuda:0' --params-dict-name='./ckpt/cvae_partition1.pkl'
```

To train CVAE on CIFAR10, run this command:

```shell
python -m train --task='same_dataset_cifar10' --partition='partitio
n1' --command='train_cvae' --device='cuda:0' --params-dict-name='./ckpt/cvae_partition1.pkl'
```

> --partition='partition1'/'partition2'/'partition3'/'partition4'/'partition5'; --params-dict-name={checkpoint name}; --device={the available GPU in your cluster}; you can change the seed by setting --seed={your seed}

## 3. CGA Stage 2 and Evaluation

To perform CGA Stage 2 and get the final result on MNIST, run this command:

```shell
python -m eval --task='same_dataset_mnist' --partition='partition1' --device='cuda:0' --params-dict-name='./ckpt/main_model_partition1.pkl' --params-dict-name2='./ckpt/cvae_partition1.pkl' --mode='CGA-energy'
```

To perform CGA Stage 2 and get the final result on CIFAR10, run this command:

```shell
python -m eval --task='same_dataset_cifar10' --partition='partition1' --device='cuda:0' --params-dict-name='./ckpt/main_model_partition1.pkl' --params-dict-name2='./ckpt/cvae_partition1.pkl' --mode='CGA-energy'
```

> --partition='partition1'/'partition2'/'partition3'/'partition4'/'partition5'; --params-dict-name={IND classifier checkpoint}; --params-dict-name2={CVAE checkpoint}--device={the available GPU in your cluster}; --mode='CGA-softmax'/'CGA-energy'; you can change the seed by setting --seed={your seed}

## 4. Apply CGA to CSI

Here we also provide codes to reproduce the new SOTA by applying CGA to [CSI](https://github.com/alinlab/CSI). See `./CSI+CGA`.
