fairseq-train data/cvss-c/fr-en/s2t \
    --user-dir DASpeech \
    --config-yaml config.yaml \
    --task nat_speech_to_text --noise full_mask \
    --arch s2t_conformer_dag --share-decoder-input-output-embed \
    --pos-enc-type rel_pos --decoder-learned-pos --attn-type espnet \
    --activation-fn gelu --apply-bert-init \
    --encoder-layers 12 --encoder-embed-dim 256 --encoder-ffn-embed-dim 2048 --encoder-attention-heads 4 \
    --decoder-layers 4 --decoder-embed-dim 512 --decoder-ffn-embed-dim 2048 --decoder-attention-heads 8 \
    --links-feature feature:position --decode-strategy lookahead \
    --max-source-positions 6000 --max-target-positions 1024 --src-upsample-scale 0.5 \
    --criterion nat_dag_loss \
    --max-transition-length 99999 \
    --glat-p 0.5:0.1@100k --glance-strategy number-random \
    --optimizer adam --adam-betas '(0.9,0.999)' --fp16 \
    --label-smoothing 0.0 --weight-decay 0.01 --dropout 0.1 --attention-dropout 0.1 --relu-dropout 0.1 \
    --lr-scheduler inverse_sqrt  --warmup-updates 10000 \
    --clip-norm 1.0 --lr 0.0005 --warmup-init-lr 1e-7 --stop-min-lr 1e-9 \
    --ddp-backend=legacy_ddp \
    --max-tokens 40000 --update-freq 2 --grouped-shuffling \
    --max-update 100000 --max-tokens-valid 20000 \
    --save-interval 1 --save-interval-updates 2000 \
    --seed 1 \
    --train-subset train --valid-subset dev \
    --validate-interval 1000 --validate-interval-updates 2000 \
    --eval-bleu --eval-bleu-args '{"iter_decode_max_iter": 0, "iter_decode_with_beam": 1}' \
    --eval-bleu-print-samples \
    --best-checkpoint-metric bleu --maximize-best-checkpoint-metric \
    --save-dir checkpoints/cvss-c.fr-en.da-transformer \
    --keep-best-checkpoints 5 \
    --keep-interval-updates 5 --keep-last-epochs 5 \
    --no-progress-bar --log-format json --log-interval 100 \
    --num-workers 8