fairseq-train data/cvss-c/fr-en/tts/ \
    --config-yaml config.yaml --train-subset train --valid-subset dev \
    --num-workers 8 --max-sentences 64 --max-update 100000 \
    --task text_to_speech --criterion fastspeech2 --arch fastspeech2 \
    --encoder-layers 4 --encoder-embed-dim 256 --encoder-attention-heads 4 \
    --decoder-layers 4 --decoder-embed-dim 256 --decoder-attention-heads 4 \
    --fft-hidden-dim 1024 \
    --clip-norm 5.0 --n-frames-per-step 1 \
    --dropout 0.1 --attention-dropout 0.1 \
    --optimizer adam --lr 5e-4 --lr-scheduler inverse_sqrt --warmup-updates 4000 --fp16 \
    --no-progress-bar --log-format json --log-interval 100 \
    --required-batch-size-multiple 1 \
    --save-interval 1 --save-interval-updates 2000 \
    --validate-interval 1000 --validate-interval-updates 2000 \
    --save-dir checkpoints/cvss-c.fr-en.fastspeech2 \
    --keep-best-checkpoints 5 \
    --keep-interval-updates 5 --keep-last-epochs 5 \
    --seed 1 --update-freq 2