# LGPred: Learning to Generate Predictor for Long-Term Time Series Forecasting

This is an offical implementation of LGPred: Learning to Generate Predictor for Long-Term Time Series Forecasting.

## Requirements

- Python 3.6
- numpy==1.22.2
- matplotlib==3.6.2
- pandas==1.5.2
- scikit-learn==1.2.2
- torch==2.0.1

Dependencies can be installed using the following command:
```bash
pip install -r requirements.txt
```

## Data 

All the required data files are included in `dataset` directory.

## Usage 

We include scripts for each dataset in `scripts` directory. 

Commands to run the experiments with LGPred

```bash
# ECL 
sh scripts/ECL.sh

# ETTh1 
sh scripts/ETTh1.sh

# ETTh2 
sh scripts/ETTh2.sh

# ETTm1 
sh scripts/ETTm1.sh

# ETTm2 
sh scripts/ETTm2.sh

# Exchange 
sh scripts/Exchange.sh

# ILI 
sh scripts/ILI.sh

# Traffic 
sh scripts/Traffic.sh

# Weather 
sh scripts/Weather.sh

```

## Acknowledgements 
We appreciate the following github repo for the valuable code base and datasets:

https://github.com/cure-lab/LTSF-Linear

https://github.com/zhouhaoyi/Informer2020

https://github.com/thuml/Autoformer




