import numpy as np
import math
import matplotlib.pyplot as plt
import pickle
from scipy.special import comb
import pandas as pd

import Real_Data
import DFlearn
import RC
import SFmodel_MLE


Dota = np.array(pd.read_csv('DOTA.csv')) #also used for jester.csv
print(Dota)

num_items = 757 #Dota[0,0]
print("num_items = ", num_items)
data_size = Dota[0,0]
print("data_size = ", data_size)

dim2 = 50
c = 0.0009 #l2 regularization parameter


#print(Dota)
#print(np.shape(Dota))

Dota = Dota[1:,:]
print("Dota = ", Dota, "size = ", np.shape(Dota)[0])

RC_accuracy_total = np.zeros((10,1))
SF_accuracy_total = np.zeros((10,1))
DF_accuracy_total = np.zeros((10,1))

for seed in range(10):

    train_data1, train_data2, train_val_data1, train_val_data2, val_data1, val_data2, test_data1, test_data2, prob_data, prob_val = Real_Data.Real_Dataset(Dota, int(num_items), seed)

    RC_accuracy = RC.RankCentrality(train_data1, train_data2, train_val_data1, train_val_data2, val_data1, val_data2, test_data1, test_data2, prob_data, prob_val, num_items)
    #print("RC_accuracy = ", RC_accuracy)

    SF_accuracy = SFmodel_MLE.SF_MLE_RealData(train_data1, train_data2, train_val_data1, train_val_data2, val_data1, val_data2, test_data1, test_data2, prob_data, prob_val, num_items)
    #print("SF_accuracy = ", SF_accuracy)

    DF_accuracy = DFlearn.Ranking(train_data1, train_data2, train_val_data1, train_val_data2, val_data1, val_data2, test_data1, test_data2, prob_data, prob_val, num_items, dim2, c)
    #print("DF_accuracy = ", DF_accuracy)

    RC_accuracy_total[seed][0] = RC_accuracy
    SF_accuracy_total[seed][0] = SF_accuracy
    DF_accuracy_total[seed][0] = DF_accuracy

np.savetxt("accuracy_RC_Dota.txt", RC_accuracy_total)
np.savetxt("accuracy_DF_Dota.txt", DF_accuracy_total)
np.savetxt("accuracy_SF_Dota.txt", SF_accuracy_total)





