import numpy as np
import math
import matplotlib.pyplot as plt

import pickle
from scipy.special import comb
import pandas as pd
import os
import sys
import pairwise_comparisonsC
import gen_embedding
import RC
import SFmodel_MLE
import DFlearn
#import Tournament_generation_DFmodel


#idx = sys.argv[1]

num_items = 100
dim = 10

#num_items = 9
#dim = 3

total_pairs = int(comb(num_items,2))

m2 = int(num_items * math.log2(num_items))

l = int(math.log2(num_items))


r = int(total_pairs/m2)

m_vals = []
l_vals = []
no_of_pairs = np.zeros(r-1)
no_of_comparisons = np.zeros(6)

for i in range(1,r):
    m3 = i*m2
    m_vals.append(m3)
    #no_of_pairs[i-1] = m3

no_of_pairs = m_vals

print(m_vals)
print(no_of_pairs)

#for i in range(0,6,1):
#    l3 = (2**i)*l2
#    l_vals.append(l3)

#no_of_comparisons = l_vals

accuracy_no_of_pairs = np.zeros(((10,r-1)))
ktc_vals = np.zeros(((10,r-1)))
ktc2_vals = np.zeros(((10,r-1)))


dim2 = 50
c = 0.00009 #l2 regularization parameter
#h_val = h_1
num_clusters = 1

'''accuracy_RC_total = []
ktc_RC_total = []

accuracy_DFlearn_total = []
ktc_DFlearn_total = []

accuracy_SF_total = []
ktc_SF_total = []'''

accuracy_RC_total = np.zeros(((10,r-1)))
accuracy_DFlearn_total = np.zeros(((10,r-1)))
accuracy_SF_total = np.zeros(((10,r-1)))

cycles_total = np.zeros(((10,r-1)))
cycle_fraction_total = np.zeros(((10,r-1)))

ktc_RC_total = np.zeros(((10,r-1)))
ktc_DFlearn_total = np.zeros(((10,r-1)))
ktc_SF_total = np.zeros(((10,r-1)))

count_iter = 0

for t in range(10):
    
    print(t)
    
    embeddings = gen_embedding.generate_embedding(num_items, dim, np.sqrt(1/dim))
    #embeddings = Tournament_generation_DFmodel.generate_tournament(num_items, dim, 8, np.sqrt(1/dim))
    #embeddings = gen_embedding.generate_embedding_uniform(num_items, dim)
    #embeddings = gen_embedding.generate_clustered_embedding(num_items, dim, num_clusters)

    U = embeddings

    prob_data = np.zeros((num_items,(num_items+1)))

    for i in range(num_items-1):
        for j in range(i+1, num_items):
    
            diff = np.abs(U[:,i] - U[:,j])
            diff2 = np.amax(diff)
            ind = np.argmax(diff)
            diff3 = (U[ind,i] - U[ind,j])
            prob = 1/(1+np.exp(-diff3))
            
            
            
            if prob >= 0.5:
               prob_data[i][j] = prob
               prob_data[i][num_items] = prob_data[i][num_items] + 1
               
            else:
               prob_data[j][i] = 1 - prob
               prob_data[j][num_items] = prob_data[j][num_items] + 1

            
    count_m = 0
    
    for m in m_vals:
    
        embedding_obj = pairwise_comparisonsC.embedding(embeddings, num_items, l, m)

        accuracy_RC, ktc_RC = RC.RankCentrality(embedding_obj, num_items, l, m)
        accuracy_SF, ktc_SF = SFmodel_MLE.SF_MLE_DFdata(embedding_obj, num_items, l, m, dim, U)
        accuracy_DFlearn, ktc_DFlearn, cycles, cycle_fraction = DFlearn.Ranking(embedding_obj, num_items, l, m, dim, dim2, prob_data) #, idx)

        
        accuracy_RC_total[count_iter][count_m] = accuracy_RC
        accuracy_SF_total[count_iter][count_m] = accuracy_SF
        accuracy_DFlearn_total[count_iter][count_m] = accuracy_DFlearn

        cycles_total[count_iter][count_m] = cycles
        cycle_fraction_total[count_iter][count_m] = cycle_fraction

        ktc_RC_total[count_iter][count_m] = ktc_RC
        ktc_SF_total[count_iter][count_m] = ktc_SF
        ktc_DFlearn_total[count_iter][count_m] = ktc_DFlearn           
        
    count_m = count_m + 1
    
count_iter = count_iter + 1

#accuracy_reshape = accuracy_no_of_pairs.reshape(accuracy_no_of_pairs.shape[0], -1)

#ktc_vals_reshape = ktc_vals.reshape(ktc_vals.shape[0], -1)

np.savetxt("accuracy_RC.txt", accuracy_RC_total)
np.savetxt("accuracy_DF.txt", accuracy_DFlearn_total)
np.savetxt("accuracy_SF.txt", accuracy_SF_total)

np.savetxt("cycles.txt", cycles_total)
np.savetxt("cycle_fraction.txt", cycle_fraction_total)

np.savetxt("ktc_vals_RC.txt", ktc_RC_total)
np.savetxt("ktc_vals_DF.txt", ktc_DFlearn_total)
np.savetxt("ktc_vals_SF.txt", ktc_SF_total)

acc_RC = np.loadtxt("accuracy_RC.txt")
acc_DF = np.loadtxt("accuracy_DF.txt")
acc_SF = np.loadtxt("accuracy_DF.txt")

acc_RC_mean = np.mean(acc_RC, axis = 0)
acc_SF_mean = np.mean(acc_SF, axis = 0)
acc_DF_mean = np.mean(acc_DF, axis = 0)

acc_RC_err = stats.sem(acc_RC, axis = 0)
acc_SF_err = stats.sem(acc_SF, axis = 0)
acc_DF_err = stats.sem(acc_DF, axis = 0)

plt.errorbar(no_of_pairs, acc_RC_mean, yerr = acc_RC_err)
plt.errorbar(no_of_pairs, acc_SF_mean, yerr = acc_SF_err)
plt.errorbar(no_of_pairs, acc_DF_mean, yerr = acc_DF_err)
plt.legend(["RankCentrality", "SF_MLE", "DFLearn"])#, loc = "upper left")
plt.title("DF Model Data", size = 20)
plt.xlabel("No. of training pairs", size = 20)
plt.ylabel("Pairwise Prediction Accuracy", size = 20)
plt.show()

