# -*- coding: utf-8 -*-
"""
Created on Tue Jun  6 12:30:16 2023

@author: William
"""

import hydra
from omegaconf import DictConfig
from typing import Optional
from src.utils import utils

log = utils.get_logger(__name__)

def create_graphs(config: DictConfig) -> Optional[float]:
    """Contains visualisation pipeline

    Args:
        config (DictConfig): Configuration composed by Hydra.

    Returns:
        tbd
    """
    
    #Load the wandb dataloaders: 
    log.info('Instantiating DataLoaders')
    dataloaders = hydra.utils.instantiate(config.dataloader)

    #Load the GraphFactory:
    log.info('Instantiating Plot Factory')
    plot_factory = hydra.utils.instantiate(config.plot_factory)
    
    log.info('Creating and Saving plot')
    #Create plot object and save graph to config output
    plot = plot_factory.create_plot(config.plot_type, dataloader=dataloaders)
    plot.plot_data(config.plot)
    #plot_factory.save_plot() #Loader and saver?
    
    
