
An example input command for each of the baselines have been provided below:

###########################################################################################################################
############## CAUSAL EVO-SAMPLE
###########################################################################################################################

python train.py --seed 1234 --method "causal_evosample" --dnn_type "mlp" --layers "2, 50, 50, 50, 50, 1" --activation "tanh" --lr 1e-3 --decay_steps 5000 --decay_rate 0.9 --lambda_ic 100. --lambda_f 1. --lambda_bc 100. --max_iter 300000 --N_f 1000 --N 1 --gate_type "tanh" --beta -0.5 --alpha 5.0 --beta_lr 1e-3 --tol 20. --grad_clip 1e-1 --system "convection" --pde_beta 50 --xgrid 512 --nt 251 --u0_str "sin(x)" --gpu_id 0 


###########################################################################################################################
############## EVO-SAMPLE
###########################################################################################################################

python train.py --seed 1234 --method "evosample" --dnn_type "mlp" --layers "2, 50, 50, 50, 50, 1" --activation "tanh" --lr 1e-3 --decay_steps 5000 --decay_rate 0.9 --lambda_ic 100. --lambda_f 1. --lambda_bc 100. --max_iter 300000 --N_f 1000 --N 1 --system "convection" --pde_beta 50 --xgrid 512 --nt 256 --u0_str "sin(x)" --gpu_id 0 

###########################################################################################################################
############## PINN
###########################################################################################################################

python train.py --seed 1234 --method "pinn" --dnn_type "mlp" --layers "2, 50, 50, 50, 50, 1" --activation "tanh" --lr 1e-3 --decay_steps 5000 --decay_rate 0.9 --lambda_ic 100. --lambda_f 1. --lambda_bc 100. --max_iter 300000 --N_f 1000 --N 1 --system "convection" --pde_beta 50 --xgrid 512 --nt 251 --u0_str "sin(x)" --gpu_id 0 

###########################################################################################################################
############## CURRICULUM REGULARIZATION
###########################################################################################################################

python train.py --seed 1234 --method "curriculum_reg" --dnn_type "mlp" --layers "2, 50, 50, 50, 50, 1" --activation "tanh" --lr 1e-4 --use_lr_scheduler "False" --lambda_ic 1. --lambda_f 1. --lambda_bc 1. --max_iter 300000 --N_f 1000 --N 1 --system "convection" --pde_beta 50 --xgrid 512 --nt 251 --u0_str "sin(x)" --gpu_id 0

###########################################################################################################################
############## CAUSAL PINNs
###########################################################################################################################

python train.py --seed 1234 --method "causal_pinn" --dnn_type "mlp" --layers "2, 50, 50, 50, 50, 1" --activation "tanh" --lr 1e-3 --decay_steps 5000 --decay_rate 0.9 --lambda_ic 100. --lambda_f 1. --lambda_bc 100. --max_iter 300000 --N 1 --system "convection" --pde_beta 50 --xgrid 512 --nt 251 --u0_str "sin(x)" --tol_list "1e-2,1e-1,1,1e1,1e2" --n_x 32 --n_t 32 --gpu_id 0