QBN = 32
assert (QBN & (QBN - 1)) == 0  # power of two
assert QBN >= 32  # `tl.dot` require minimum of 32


class QConfig:
    def __init__(
        self,
        init_bit: float = 6.0,
        target_bit: float = 4.0,
        block_size: int = QBN,
        is_diffq: bool = False,
        is_discrete_uniform: bool = False,
    ):
        self.init_bit = init_bit
        self.target_bit = target_bit
        self.block_size = block_size
        self.is_diffq = is_diffq
        self.is_discrete_uniform = is_discrete_uniform

        assert (block_size & (block_size - 1)) == 0  # power of two
        assert block_size >= 32  # `tl.dot` require minimum of 32
