from typing import Dict

from .base import *

selector_scores_registry: Dict[str, BaseSelectorScore] = {}


def register_selector_score(score_name: str):
    def register_model_cls(cls):
        if score_name in selector_scores_registry:
            raise ValueError(f"Cannot register duplicate score ({score_name})")
        selector_scores_registry[score_name] = cls
        return cls

    return register_model_cls


def get_selector_score(score_name: str, **kwargs) -> BaseSelectorScore:
    if score_name not in selector_scores_registry:
        raise ValueError(f"Score {score_name} not found")
    return selector_scores_registry[score_name](**kwargs)


def get_selector_score_names():
    return list(selector_scores_registry.keys())


from .doctor import *
