function [A] = GetDataSetL0SPCA(iwhich)
rand('seed',0); randn('seed',0);

switch iwhich
    case 11 % nonsparse
        load mnist;
        m = 1500;
        A = RandomSelCol(x',m)'; A = CenterData(A);
    case 12
        load mnist;
        m = 2500;
        A = RandomSelCol(x',m)'; A = CenterData(A);
        
    case 21 % nonsparse
        %         load cnn_4096d_Caltech;
        %         m = 1500;dim = 500;
        %         A = RandomSelCol(x',m)';
        %         A = RandomSelCol(A,dim);
        %         A = CenterData(A);
        load TDT2;
        m = 1500; dim = 500;
        A = RandomSelCol(fea',m)';
        A = RandomSelCol(A,dim);
        A = CenterData(A);
        
    case 22
        %         load cnn_4096d_Caltech;
        %         m = 2500;dim = 500;
        %         A = RandomSelCol(x',m)';
        %         A = RandomSelCol(A,dim);
        %         A = CenterData(A);
        load TDT2;
        m = 3000; dim = 500;
        A = RandomSelCol(fea',m)';
        A = RandomSelCol(A,dim);
        A = CenterData(A);
        
    case 31 % nonsparse
        load sector_train;
        m = 1500; dim = 500;
        A = RandomSelCol(x',m)';
        A = RandomSelCol(A,dim);
        A = CenterData(A);
    case 32
        load sector_train;
        m = 2500; dim = 500;
        A = RandomSelCol(x',m)';
        A = RandomSelCol(A,dim);
        A = CenterData(A);
        
    case 41 % nonsparse
        A = RandomSampling(1500,500); A = CenterData(A);
    case 42
        A = RandomSampling(2500,500); A = CenterData(A);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
    case 111 % nonsparse
        A = RandomSampling(2000,500); A = CenterData(A);
    case 112
        A = RandomSampling(10000,500); A = CenterData(A);
        
    case 121 % nonsparse
        load mnist;
        m = 2000;
        A = RandomSelCol(x',m)'; A = CenterData(A);
    case 122
        load mnist;
        m = 5000;
        A = RandomSelCol(x',m)'; A = CenterData(A);
        
    case 131 % nonsparse
        %         load cnn_4096d_Caltech_256;
        %         m = 2000; dim = 500;
        %         A = RandomSelCol(feat',m)';
        %         A = RandomSelCol(A,dim);
        %         A = CenterData(A);
        
        load TDT2;
        m = 2000; dim = 500;
        A = RandomSelCol(fea',m)';
        A = RandomSelCol(A,dim);
        A = CenterData(A);
        
        
    case 132
        %         load cnn_4096d_Caltech_256;
        %         m = 5000; dim = 500;
        %         A = RandomSelCol(feat',m)';
        %         A = RandomSelCol(A,dim);
        %         A = CenterData(A);
        load TDT2;
        m = 5000; dim = 500;
        A = RandomSelCol(fea',m)';
        A = RandomSelCol(A,dim);
        A = CenterData(A);
        
    case 141 % nonsparse
        load sector_train;
        m = 2000;dim = 500;
        A = RandomSelCol(x',m)';
        A = RandomSelCol(A,dim);
        A = CenterData(A);
        
    case 142
        load sector_train;
        m = 5000;
        dim = 500;
        A = RandomSelCol(x',m)';
        A = RandomSelCol(A,dim);
        A = CenterData(A);
        
        
end

A = A / norm(A,'fro');

function A = RandomSampling(M, N)
A = randn(M, N);  % Generate random values from a Gaussian distribution

% Normalize the rows of A to have unit norm
for i = 1:M
    A(i, :) = A(i, :) / norm(A(i, :));
end