function demo_L0PCA1000
% min_X  0.5/m*||A-A*X*X'||_F^2 + rho ( ||X||_1 - ||X||_{topk} ), s.t. X'X = I
% min_X  0.5/m*||A-A*X*X'||_F^2 + rho ( ||X||_1 - ||X||_{topk} ), s.t. X'X = I
% min_X - 0.5/m*mdot(A,A*X*X') + const + rho ( ||X||_1 - ||X||_{topk} ), s.t. X'X = I
% const = 0.5/m*fnorm(A)^2

clc;close all;clear all;
addpath('util','data','solver');
rand('seed',1);
randn('seed',1);

dat_rho = 5;

time_limits = [20 20 20 20 20 20 20 20]*1.5;

rs          = [20 20 20 20 20 20 20 20];
i_data      = [11 12 21 22 31 32 41 42];



for iii = 1:8
    
    iwhich = i_data(iii);
    r = rs(iii);
    timeLimit = time_limits(iii);
    A = GetDataSetL0SPCA(iwhich);
    [m,n] = size(A);
    NormA = MatrixSpectralNorm(A);
    X0 = orth(randn(n,r));
    const = 0.5*fnorm(A)^2/m;
    k = round(n*r*0.5);
    beta0 = dat_rho*10;
    max_iter = 1e100;
    alg_xi = 2;
    timeIntervel = 2; % Record the objective value in every timeIntervel second
    flag = 1; % Update the Multiplier
    [X1,fobjs1,ts1] = L0SPCA_OADMM_EP(X0,A,NormA,const,dat_rho,dat_rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,flag);
    [X2,fobjs2,ts2] = L0SPCA_OADMM_RR(X0,A,NormA,const,dat_rho,dat_rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,flag,-1);
    betaRADMM = 100;
    [X3,fobjs3,ts3] = L0SPCA_OADMM_RR(X0,A,NormA,const,dat_rho,dat_rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,flag,betaRADMM);
    betaRADMM = 10000;
    [X4,fobjs4,ts4] = L0SPCA_OADMM_RR(X0,A,NormA,const,dat_rho,dat_rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,flag,betaRADMM);
    flag = 0;
    [X5,fobjs5,ts5] = L0SPCA_OADMM_EP(X0,A,NormA,const,dat_rho,dat_rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,flag);
    [X6,fobjs6,ts6] = L0SPCA_OADMM_RR(X0,A,NormA,const,dat_rho,dat_rho,k,max_iter,beta0,alg_xi,timeIntervel,timeLimit,flag,-1);
    [X7,fobjs7,ts7] = L0SPCA_SubGrad(X0,A,const,dat_rho,dat_rho,k,max_iter,timeIntervel,timeLimit);
    
    
    figure('color','w');
    myplot = @semilogy;
    pcolor = loadcolor;
    myplot(ts1,fobjs1,'--kv','LineWidth',3,'MarkerSize',5,'color', pcolor.red); hold on;
    myplot(ts2,fobjs2,'-.mo','LineWidth',3,'MarkerSize',5,'color',  pcolor.blue); hold on;
    myplot(ts3,fobjs3,'--kv','LineWidth',3,'MarkerSize',5,'color', pcolor.pink); hold on;
    myplot(ts4,fobjs4,'-.b^','LineWidth',3,'MarkerSize',5,'color', pcolor.orange ); hold on;
    myplot(ts5,fobjs5,'--s','LineWidth',3,'MarkerSize',5,'color', pcolor.green); hold on;
    myplot(ts6,fobjs6,'-s','LineWidth',3,'MarkerSize',5,'color', pcolor.crimson); hold on;
    myplot(ts7,fobjs7,'--kd','LineWidth',3,'MarkerSize',5,'color', pcolor.purple); hold on;

    
    grid on;
    hleg=legend('OADMM-EP','OADMM-RR','RADMM-I','RADMM-II','SPGM-EP','SPGM-RR','SubGrad');
    set(hleg,'FontSize',20,'FontWeight','normal');
    set(hleg,'Fontname','times new Roman');
    set(hleg,'Location','NorthEast');
    set(gca,'Fontsize', 19);
    set(hleg, 'Color', 'none');
    xlabel('Time (seconds)','FontSize',20)
    ylabel('Objective','FontSize',20,'interpreter','latex')
    all_fobj = [fobjs1;fobjs2;fobjs3;fobjs4;fobjs5;fobjs6;fobjs7];
    axis([0,timeLimit+1,min(all_fobj),max(all_fobj)]);
    fprintf('\n');
    set(gcf,'paperpositionmode','auto')
    print(sprintf('%s_%d.eps',mfilename,iwhich),'-depsc2','-loose');
    print(sprintf('%s_%d.png',mfilename,iwhich),'-dpng');
%     print(sprintf('%s_%d.pdf',mfilename,iwhich),'-dpdf', '-r0');
    
    One = [];
    One.ts1 = ts1; One.fobjs1 = fobjs1;
    One.ts2 = ts2; One.fobjs2 = fobjs2;
    One.ts3 = ts3; One.fobjs3 = fobjs3;
    One.ts4 = ts4; One.fobjs4 = fobjs4;
    One.ts5 = ts5; One.fobjs5 = fobjs5;
    One.ts6 = ts6; One.fobjs6 = fobjs6;
    One.ts7 = ts7; One.fobjs7 = fobjs7;
    result{iii} = One;
    savefile = sprintf('%s_%d.mat',mfilename,dat_rho);
    save(savefile, 'result');
end






