function [X,fobjs,ts] = L0SPCA_SubGrad(X,A,const,rho1,rho2,k,max_iter,timeIntervel,timeLimit)
% min_X  -0.5/m*mdot(A,A*X*X') + const + rho1 ||X||_1 - rho2 ||X||_{topk}, s.t. X'X = I
[m,n] = size(A);

initt = clock;
last_rec_clock = initt;
HandleObj = @(X) L0SPCA_ComputeObj(X,A,rho1,rho2,k,const,m);


r = size(X,2);
bottom = n*r - k;
X = OrthProj(X);

ts = []; fobjs = [];
fobj = HandleObj(X);
fobjs = [fobjs;fobj];
ts = [ts;etime(clock,initt)];

fprintf('SubGrad: begin\n');

for iter = 1:max_iter
    
    SubGrad = -1/m*A'*(A*X) + rho1*sign(X) - rho2*tksum(X,k);
    Delta = - 0.1*SubGrad/iter;
    X = OrthProj(X + Delta);
    %      X = retr(X,Delta);
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit, break; end
        fprintf('iter:%d, fobj:%f\n',iter,fobj);
    end
end
fprintf('SubGrad: end\n');
