from TreeNode import (
    TreeNode,
    create_tree_from_strings,
    dfs_with_error_check,
)
from prompts import initial_generation_prompt
from utils import parse_problem, parse_to_val
from openai import OpenAI

client = OpenAI(api_key="")

SAMPLES = 25
MODEL = "gpt-4o"

for i in range(2, 102):
    filename = f"instances/blocksworld/generated/instance-{i}.pddl"
    with open(filename, "r") as file:
        content = file.read()
    content = content.lstrip()
    init, goal = parse_problem(content)

    problem_instance = f"As initial conditions I have that, {', '.join(init)}.\nMy goal is to have that {goal}."
    completion = client.chat.completions.create(
        model=MODEL,
        messages=initial_generation_prompt
        + [
            {
                "role": "user",
                "content": problem_instance,
            }
        ],
        temperature=0.7,
        n=SAMPLES,
    )
    llm_answers = [completion.choices[i].message.content for i in range(SAMPLES)]
    llm_answers = ["\n".join(answer.split("\n")[1:-1]) for answer in llm_answers]
    llm_answers = [parse_to_val(answer) for answer in llm_answers]

    tree = create_tree_from_strings(llm_answers)

    success, error_count = dfs_with_error_check(tree, filename, error_limit=10)
    print(f"Success: {success}, Error count: {error_count}")
