<!--
 * @Author: 
 * @Email: 
 * @Date: 2021-05-12 13:34:40
 * @LastEditTime: 2021-05-30 22:12:06
 * @Description: 
-->

# LiDAR Scene Generation

## Environment Requirements

We use Python 3.7 in Anaconda environment and use pip to install the following packages:
```
torch==1.8.1
matplotlib==3.1.3
numpy==1.20.3
plyfile==0.7.4    # for renderer
botorch==0.4.0    # for BO
gpytorch==1.4.2   # for BO
pandas==1.2.4
pyyaml==5.4.1
scipy==1.6.3 
tqdm==4.61.0
```

CUDA that is supported by torch==1.8.1 is also required to compile the renderer and victim models. We use CUDA 10.2 since sponcv requires higher verison than 10.2


## Download Processed Datasets

Download the dataset from this [link](https://drive.google.com/drive/folders/1L69XSjluJ6-ixpN9SUvTb-za4KG_PgMv?usp=sharing) and put them into the *./data* folder.


## Train T-VAE Model

If you want to train the models from scratch, you need to run:
```angularjs
# train model
python3 train.py --type=0 
# test the trained model
python3 train.py --type=1
```

You can also download the pre-trained T-VAE model from this [link](https://drive.google.com/drive/folders/1bG9smkxmHl1oW2orS3HvMj_-UPPbgVz5?usp=sharing) and put them into the *./models* folder.


## Prepare Victim Segmentation Models

The victim models are trained on Semantic-Kitti dataset. If you want to train them from scratch, please firstly download the dataset from this [link](http://www.semantic-kitti.org/dataset.html#download).

You can donwload all pre-trained victim models from this [link](https://drive.google.com/drive/folders/1F1rgWVbaGV2QeJ4170N32ruPD-isC8Md?usp=sharing), and put all files to local folders with corresponding names.

### PointNet++

```angularjs
cd ./Victims/PointNet2/pointnet2
python3 setup.py install
# if you want to train from scratch, please use the following commands
python3 main.py --mode=train
```

### SqueezeSegV3

Nothing need to be done.

### PolarSeg

Some packages need to be additionally installed
```
Cython==0.29.23
dropblock==0.3.0
numba==0.53.1
torch-scatter==2.0.6
```

### Cylinder3D

Some packages need to be additionally installed
```
Cython==0.29.23
dropblock==0.3.0
numba==0.53.1
torch-scatter==2.0.6
strictyaml==1.4.0
ruamel.yaml==0.16.12
```

[spconv](https://github.com/traveller59/spconv) need to be mannuly installed, thus you may need to follow the instruction and compile by yourself.
Be sure to use ```git clone```with ```--recursive``` to install thirdparty libraries.
Note that the lastest ruamel.yaml may not work with current code, please use 0.16.12.

## Scene Generation (Attack)

We implement a differentiable render to create lidar scenarios by placing vehicle objects in a background. 
You need to download the background and vehicle object files from this [link](https://drive.google.com/drive/folders/11X4ZxLFmn20mnZle1eDmQ1pkv-PInTPL?usp=sharing).
To attack pointcloud segmentation models, you can use the following commands

```angularjs
cd Generation
# Point Attack 
python3 attack.py --method=point --victim=[pointnet2/polarseg/cylinder3d/squeezeseg] --background_name=[background_2/background_3]
# Pose Attack
python3 attack.py --method=pose --victim=[pointnet2/polarseg/cylinder3d/squeezeseg] --background_name=[background_2/background_3]
# Scene Attack
python3 attack.py --method=tvae --victim=[pointnet2/polarseg/cylinder3d/squeezeseg] --background_name=[background_2/background_3]
```

background_2 is the intersection background and background_3 is the highway background.