'''
@Author: Wenhao Ding
@Email: wenhaod@andrew.cmu.edu
@Date: 2020-07-09 13:51:09
LastEditTime: 2021-05-30 20:27:23
@Description:
'''

import argparse
from trainer import Trainer
import numpy as np


parser = argparse.ArgumentParser(description="Arg parser")
parser.add_argument("--mode", type=str, default='train', help='[train/eval]')
parser.add_argument("--data_name", type=str, default='kitti', help='used in train or eval mode')

# parameters for training
parser.add_argument("--continue_training", type=bool, default=True)
parser.add_argument("--max_epochs", type=int, default=100)
parser.add_argument('--workers', type=int, default=8)
parser.add_argument("--batch_size", type=int, default=8)
parser.add_argument('--lr', type=float, default=0.002)
parser.add_argument('--lr_decay', type=float, default=0.2)
parser.add_argument('--lr_clip', type=float, default=0.000001)
parser.add_argument('--decay_step_list', type=list, default=[50, 70, 80, 90])
parser.add_argument('--weight_decay', type=float, default=0.001)
parser.add_argument("--save_interval", type=int, default=1)
parser.add_argument("--npoints", type=int, default=100000, help='number of points input into the model 130000 for kitti and 100000 for argo')

# parameters for paths
parser.add_argument("--model_path", type=str, default='./model')
parser.add_argument("--log_path", type=str, default='./log')
parser.add_argument("--kitti_path", type=str, default='/home/wenhao/Dataset/Semantic_KITTI')

args = parser.parse_args()
trainer = Trainer(args)

if args.mode == 'train':
    trainer.train_and_eval(name=args.data_name)
elif args.mode == 'eval':
    trainer.evaluation(name=args.data_name)
else:
    raise NotImplementedError()
