#!/bin/bash

DATA_NAME="mmivqd_base"
CURRENT_TIME=$(date +"%Y%m%d%H%M%S")
FILE_NAME="geminipro_${CURRENT_TIME}"

python -m vlms.geminipro.geminipro_vqa_updbench \
    --data-name ${DATA_NAME} \
    --answers-file ./output/ivqd/answers/geminipro/instruction/${DATA_NAME:0:-5}_instruction/${FILE_NAME}.jsonl \
    --single-pred-prompt \
    --gemini-api-key ${GEMINI_API_KEY} \
    --prompt_id 3

mkdir -p output/ivqd/answers_upload/geminipro/instruction/${DATA_NAME:0:-5}_instruction

python -m scripts.convert_mmbench_for_submission \
    --data-name ${DATA_NAME} \
    --result-dir ./output/ivqd/answers/geminipro/instruction/${DATA_NAME:0:-5}_instruction \
    --upload-dir ./output/ivqd/answers_upload/geminipro/instruction/${DATA_NAME:0:-5}_instruction \
    --experiment ${FILE_NAME}