#!/bin/bash

CURRENT_TIME=$(date +"%Y%m%d%H%M%S")

export PYTHONPATH="$PYTHONPATH:$PWD/vlms"

deepspeed --master_port 29601 --include localhost:0,1 vlms/llava/train/train_mem.py \
    --lora_enable True --lora_r 128 --lora_alpha 256 --mm_projector_lr 2e-5 \
    --deepspeed data/inst_tuning/zero3.json \
    --model_name_or_path liuhaotian/llava-v1.6-34b \
    --version mistral_direct \
    --data_path data/inst_tuning/upd_tuning_data_20240303.json \
    --image_folder data/inst_tuning \
    --vision_tower openai/clip-vit-large-patch14-336 \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --image_aspect_ratio pad \
    --group_by_modality_length True \
    --bf16 True \
    --output_dir ./checkpoints/llava-v1.6-34b-task-lora_${CURRENT_TIME} \
    --num_train_epochs 1 \
    --per_device_train_batch_size 8 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 4 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 50000 \
    --save_total_limit 1 \
    --learning_rate 1e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb
