#!/usr/bin/env python

import subprocess
import sys
import glob
import os
import json


benchmark_dir = sys.argv[1]
results = {}
javascript_files = glob.glob(os.path.join(benchmark_dir, "*.js"))
java_main_class = "com.ibm.wala.examples.drivers.JSCallGraphDriver"
total_bugs = 0
for javascript_file in javascript_files:

    gradle_cmd_args = [
        "./gradlew",
        "run",
        "-PmainClass=" + java_main_class,
        "--args=" + javascript_file,
    ]

    # print(" ".join(gradle_cmd_args))

    result = subprocess.run(gradle_cmd_args, capture_output=True, text=True)
    number_of_bugs = result.stdout.count("Bug")
    print(
        f"Number of bugs found in {os.path.basename(javascript_file)}: "
        + str(number_of_bugs)
    )
    results[os.path.basename(javascript_file)] = number_of_bugs
    total_bugs += number_of_bugs
    # print(javascript_file)
print(f"total number of bugs found: {total_bugs}")
with open("wala_results.json", 'w') as f:
    f.write(json.dumps(results, indent=2))
