package com.ibm.wala.examples.analysis.js;

import com.ibm.wala.cast.ipa.callgraph.AstCallGraph.ScriptFakeRoot;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.loader.DynamicCallSiteReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Iterator;
import java.util.Set;

public class testScriptEntryPoint extends Entrypoint {
    public testScriptEntryPoint(IMethod scriptCodeBody) {
      super(scriptCodeBody);
    }

    @Override
    public CallSiteReference makeSite(int programCounter) {
        return new DynamicCallSiteReference(JavaScriptTypes.CodeBody, programCounter);
    }

    @Override
    public TypeReference[] getParameterTypes(int i) {
        TypeReference[] result = {JavaScriptTypes.Object};
        if (i == 0) {
            return new TypeReference[] {getMethod().getDeclaringClass().getReference()};
        } 
        return new TypeReference[] {JavaScriptTypes.Object}; 
    }

    @Override
    public int getNumberOfParameters() {
      return getMethod().isStatic() ? 0 : 1;
    }

    @Override
    public SSAAbstractInvokeInstruction addCall(AbstractRootMethod m) {
      CallSiteReference site = makeSite(0);

      if (site == null) {
        return null;
      }

      int functionVn = getMethod().isStatic() ? -1 : makeArgument(m, 0);
      int paramVns[] = new int[Math.max(0, getNumberOfParameters() - 1)];
      for (int j = 0; j < paramVns.length; j++) {
        paramVns[j] = makeArgument(m, j + 1);
      }

      return ((ScriptFakeRoot) m).addDirectCall(functionVn, paramVns, site);
    }
  }
