package com.ibm.wala.examples.drivers;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.cast.js.callgraph.fieldbased.FieldBasedCallGraphBuilder;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.translator.CAstRhinoTranslatorFactory;
import com.ibm.wala.cast.js.util.CallGraph2JSON;
import com.ibm.wala.cast.js.util.FieldBasedCGUtil;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.IMethod.SourcePosition;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.intset.OrdinalSet;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class FieldBasedJSCallGraphDriver {

  private static String resolveStringConstant(IR ir, int valueNumber) {
    SymbolTable symTab = ir.getSymbolTable();
    if (symTab.isConstant(valueNumber)) {
        Object val = symTab.getConstantValue(valueNumber);
        if (val instanceof String) {
            return (String) val;
        }
    }
    return null;
}
  /**
   * Usage: JSCallGraphDriver path_to_js_file
   *
   * @param args
   * @throws WalaException
   * @throws CancelException
   * @throws IOException
   * @throws IllegalArgumentException
   */
  public static void main(String[] args)
      throws IllegalArgumentException, IOException, CancelException, WalaException, InvalidClassFileException {
    Path path = Paths.get(args[0]);
    FieldBasedCGUtil f = new FieldBasedCGUtil(new CAstRhinoTranslatorFactory());
    URL url = path.toUri().toURL();
    FieldBasedCallGraphBuilder.CallGraphResult results =
        f.buildScriptCG(url, FieldBasedCGUtil.BuilderType.OPTIMISTIC_WORKLIST, null, true);
    CallGraph CG = results.getCallGraph();
    PointerAnalysis<?> PA = results.getPointerAnalysis();
    HeapGraph<? extends InstanceKey> HG = PA.getHeapGraph();
    HeapModel HM = PA.getHeapModel();
    for (Object key : Iterator2Iterable.make(HG.iterator())) {
      if (key instanceof LocalPointerKey && !key.toString().contains("prologue")) {
        // get the local variable name of the key
        System.out.println("HERE");
        CGNode node = ((LocalPointerKey)key).getNode();
        IR ir = node.getIR();
        IMethod method = ir.getMethod();
        int valueNumber = ((LocalPointerKey)key).getValueNumber();
        DefUse du = node.getDU();
        String[] localNames = ir.getLocalNames(0, valueNumber);
        
        if (localNames != null && localNames.length > 0) {
          // Get all the instance keys that this PointerKey points to. 
          for (Object sucNode : Iterator2Iterable.make(HG.getSuccNodes(key))) {
            System.out.println(localNames[0] + " --> " + sucNode.hashCode());
          }
        }
      }
    }

    for (CGNode node : CG) {
      IR ir = node.getIR();
      if (ir == null) continue;
      
     // IBytecodeMethod method = (IBytecodeMethod) node.getMethod();
      IMethod method = node.getMethod(); 
      if (ir != null && false) {
        for (SSAInstruction instr : ir.getInstructions()) {
          if (instr != null && method.getSourcePosition(instr.iIndex()) != null &&
              !method.getSourcePosition(instr.iIndex()).toString().contains("prologue")) {
            System.out.println(instr.toString() + ":  " + method.getSourcePosition(instr.iIndex()) + ": " + instr.getClass().getName());
          }
        }
      }
      for (SSAInstruction instr : ir.getInstructions()) {
          if (instr instanceof SSAGetInstruction) {
            //int index = method.getInstructionIndex(instr.iIndex());
            //AbstractSourcePosition sourcePos = (AbstractSourcePosition) method.getSourcePosition(index);
            SSAGetInstruction get = (SSAGetInstruction) instr;
            SourcePosition  sourcePos = method.getSourcePosition(get.iIndex());
            int line = (sourcePos != null) ? sourcePos.getFirstLine() : -1;
            String field = get.getDeclaredField().getName().toString();

            if (line != -1 && !sourcePos.toString().contains("prologue")) {
                List<String> lines = Files.readAllLines(Paths.get(args[0]));
                if (line <= lines.size()) {
                  int objVar = get.getRef(); // e.g., v2
                  int maxValue = node.getIR().getSymbolTable().getMaxValueNumber();
                  if (objVar > maxValue || objVar < 0 || node.getIR().getSymbolTable().isConstant(objVar) == true) {
                      continue;
                  }
                  PointerKey pk = HM.getPointerKeyForLocal(node, objVar);
                  OrdinalSet<? extends InstanceKey> pts = PA.getPointsToSet(pk);

                  for (InstanceKey ik : pts) {
                      System.out.println("  Possible base object: " + ik);
                  }
                    System.out.println("Possible field read: " + field + " at line " + line);
                    System.out.println("  >> " + lines.get(line - 1));
                    System.out.println("  >> PointerKey: " + pk.toString());
                    System.out.println("  >> obj: v" + objVar);
                    System.out.println("  >> points to set: " + Integer.toString(pts.size()));
                    System.out.println("  >> " + instr.toString(ir.getSymbolTable()));
                }
            }
          }
          
          if (instr instanceof JavaScriptPropertyRead) {
            JavaScriptPropertyRead read = (JavaScriptPropertyRead) instr;
            SourcePosition  sourcePos = method.getSourcePosition(read.iIndex());
            int line = (sourcePos != null) ? sourcePos.getFirstLine() : -1;
            int base = read.getObjectRef();   // the object (`obj`)
            int property = read.getMemberRef(); // the property name or variable holding it
            int result = read.getDef();  // where the value is stored

            SymbolTable symtab = ir.getSymbolTable();
            String resolvedProp = null;
            if (symtab.isConstant(property) && symtab.getConstantValue(property) instanceof String) {
                resolvedProp = (String) symtab.getConstantValue(property);
            }


            if (line != -1 && !sourcePos.toString().contains("prologue")) {
              PointerKey pk = HM.getPointerKeyForLocal(node, base);
              OrdinalSet<? extends InstanceKey> pts = PA.getPointsToSet(pk);

              for (InstanceKey ik : pts) {
                  System.out.println("  Possible base object: " + ik);
              }
              
              System.out.println("JavaScriptPropertyRead:");
              System.out.println("  At line: " + line);
              System.out.println("  obj: v" + base);
              System.out.println("  points to set: " + Integer.toString(pts.size()));
              System.out.println("  property: v" + property + (resolvedProp != null ? " (\"" + resolvedProp + "\")" : ""));
            }
        }
            
      }
    
  }
  }
}
