import subprocess
import sys
import glob
import time
import os
import json

num_absent = 0
num_null = 0

def get_buggy_lines(output):
    global num_absent
    global num_null
    """
    Extracts buggy lines from the output of TAJS.
    """
    lines = set()
    for line in output.splitlines():
        line = line.lower()
        if "reading absent property" in line or "accessing property of null" in line:
            lines.add(':'.join(line.split(':')[:-1]))
            if "reading absent property" in line:
                num_absent += 1
            else:
                num_null += 1
    return lines

results = {}
start = time.time()
benchmarks_dir = sys.argv[1]
javascript_files = glob.glob(os.path.join(benchmarks_dir, "*.js"))
total_bugs = 0
for javascript_file in javascript_files:
    if "delta" in javascript_file:
        continue
    cmd = f"java -jar /scratch/mi27950/absint_ai/baselines/TAJS/tajs-all.jar -analysis-limitations-warn-only -dom -low-severity {javascript_file}".split(' ')
    #cmd = f"java -jar /scratch/mi27950/absint_ai/baselines/TAJS/tajs-all.jar -analysis-limitations-warn-only -dom -low-severity -no-concrete -no-control-sensitivity -no-filtering -no-object-sensitivity {javascript_file}".split(' ')
    #print(cmd)
    result = subprocess.run(cmd, capture_output=True, text=True)
    buggy_lines = get_buggy_lines(result.stdout)
    total_bugs += len(buggy_lines)
    print(
        f"Number of bugs found in {os.path.basename(javascript_file)}: "
        + str(len(buggy_lines))
    )
    results[os.path.basename(javascript_file)] = str(len(buggy_lines))

end = time.time()
print(f"total time: {end - start}")
print(f"total number of bugs found TAJS: {total_bugs}")
print(f"Num absent: {num_absent}")
with open("tajs_results.json", 'w') as f:
    f.write(json.dumps(results,indent=2))
print(f"Num null: {num_null}")
