const gridDisplay = document.querySelector('.grid')
const scoreDisplay = document.getElementById('score')
const resultDisplay = document.getElementById('result')
var squares = []
const width = GetInt(document.getElementById('width'))
var score = 0

//create the playing board
function createBoard() {
  for (var i=0; i < width*width; i++) {
    var square = document.createElement('div')
    square.innerHTML = 0
    gridDisplay.appendChild(square)
    squares.push(square)
  }
  generate()
  generate()
}
createBoard()

//generate a new number
function generate() {
  var randomNumber = Math.floor(Math.random() * squares.length)
  if (squares[randomNumber].innerHTML == 0) {
    squares[randomNumber].innerHTML = 2
    checkForGameOver()
  } else generate()
}

function moveRight() {
  var total = width * width
  for (var i=0; i < total; i++) {
    if (i % width  === 0) {
      var totalOne = squares[i].innerHTML
      var totalTwo = squares[i+1].innerHTML
      var totalThree = squares[i+2].innerHTML
      var totalFour = squares[i+3].innerHTML
      var row = [parseInt(totalOne), parseInt(totalTwo), parseInt(totalThree), parseInt(totalFour)]

      var filteredRow = row.filter(function (num) {return num})
      var missing = 4 - filteredRow.length
      var zeros = Array(missing).fill(0)
      var newRow = zeros.concat(filteredRow)

      squares[i].innerHTML = newRow[0]
      squares[i +1].innerHTML = newRow[1]
      squares[i +2].innerHTML = newRow[2]
      squares[i +3].innerHTML = newRow[3]
    }
  }
}

function moveLeft() {
  for (var i=0; i < 16; i++) {
    if (i % 4 === 0) {
      var totalOne = squares[i].innerHTML
      var totalTwo = squares[i+1].innerHTML
      var totalThree = squares[i+2].innerHTML
      var totalFour = squares[i+3].innerHTML
      var row = [parseInt(totalOne), parseInt(totalTwo), parseInt(totalThree), parseInt(totalFour)]

      var filteredRow = row.filter(function (num) {return num})
      var missing = 4 - filteredRow.length
      var zeros = Array(missing).fill(0)
      var newRow = filteredRow.concat(zeros)

      squares[i].innerHTML = newRow[0]
      squares[i +1].innerHTML = newRow[1]
      squares[i +2].innerHTML = newRow[2]
      squares[i +3].innerHTML = newRow[3]
    }
  }
}


function moveUp() {
  for (var i=0; i < 4; i++) {
    var totalOne = squares[i].innerHTML
    var totalTwo = squares[i+width].innerHTML
    var totalThree = squares[i+(width*2)].innerHTML
    var totalFour = squares[i+(width*3)].innerHTML
    var column = [parseInt(totalOne), parseInt(totalTwo), parseInt(totalThree), parseInt(totalFour)]

    var filteredColumn = column.filter(function (num) {return num})
    var missing = 4 - filteredColumn.length
    var zeros = Array(missing).fill(0)
    var newColumn = filteredColumn.concat(zeros)

    squares[i].innerHTML = newColumn[0]
    squares[i +width].innerHTML = newColumn[1]
    squares[i+(width*2)].innerHTML = newColumn[2]
    squares[i+(width*3)].innerHTML = newColumn[3]
  }
}

function moveDown() {
  for (var i=0; i < 4; i++) {
    var totalOne = squares[i].innerHTML
    var totalTwo = squares[i+width].innerHTML
    var totalThree = squares[i+(width*2)].innerHTML
    var totalFour = squares[i+(width*3)].innerHTML
    var column = [parseInt(totalOne), parseInt(totalTwo), parseInt(totalThree), parseInt(totalFour)]

    var filteredColumn = column.filter(function (num) {return num})
    var missing = 4 - filteredColumn.length
    var zeros = Array(missing).fill(0)
    var newColumn = zeros.concat(filteredColumn)

    squares[i].innerHTML = newColumn[0]
    squares[i +width].innerHTML = newColumn[1]
    squares[i+(width*2)].innerHTML = newColumn[2]
    squares[i+(width*3)].innerHTML = newColumn[3]
  }
}

function combineRow() {
  for (var i =0; i < 15; i++) {
    if (squares[i].innerHTML === squares[i +1].innerHTML) {
      var combinedTotal = parseInt(squares[i].innerHTML) + parseInt(squares[i +1].innerHTML)
      squares[i].innerHTML = combinedTotal
      squares[i +1].innerHTML = 0
      score += combinedTotal
      scoreDisplay.innerHTML = score
    }
  }
  checkForWin()
}

function combineColumn() {
  for (var i =0; i < 12; i++) {
    if (squares[i].innerHTML === squares[i +width].innerHTML) {
      var combinedTotal = parseInt(squares[i].innerHTML) + parseInt(squares[i +width].innerHTML)
      squares[i].innerHTML = combinedTotal
      squares[i +width].innerHTML = 0
      score += combinedTotal
      scoreDisplay.innerHTML = score
    }
  }
  checkForWin()
}

//assign functions to keyCodes
function control(e) {
  if(e.keyCode === 37) {
    keyLeft()
  } else if (e.keyCode === 38) {
    keyUp()
  } else if (e.keyCode === 39) {
    keyRight()
  } else if (e.keyCode === 40) {
    keyDown()
  }
}

function keyRight() {
  moveRight()
  combineRow()
  moveRight()
  generate()
}

function keyLeft() {
  moveLeft()
  combineRow()
  moveLeft()
  generate()
}

function keyUp() {
  moveUp()
  combineColumn()
  moveUp()
  generate()
}

function keyDown() {
  moveDown()
  combineColumn()
  moveDown()
  generate()
}

//check for the number 2048 in the squares to win
function checkForWin() {
  for (var i=0; i < squares.length; i++) {
    if (squares[i].innerHTML == 2048) {
      resultDisplay.innerHTML = 'You WIN'
      document.removeEventListener('keyup', control)
      setTimeout(function() { clear()}, 3000)
    }
  }
}

//check if there are no zeros on the board to lose
function checkForGameOver() {
  var zeros = 0
  for (var i=0; i < squares.length; i++) {
    if (squares[i].innerHTML == 0) {
      zeros++
    }
  }
  if (zeros === 0) {
    resultDisplay.innerHTML = 'You LOSE'
    document.removeEventListener('keyup', control)
    setTimeout(function() { clear()}, 3000)
  }
}

//clear timer
function clear() {
  clearInterval(myTimer)
}


//add colours
function addColours() {
  for (var i=0; i < squares.length; i++) {
    if (squares[i].innerHTML == 0) squares[i].style.backgroundColor = '#afa192'
    else if (squares[i].innerHTML == 2) squares[i].style.backgroundColor = '#eee4da'
    else if (squares[i].innerHTML  == 4) squares[i].style.backgroundColor = '#ede0c8'
    else if (squares[i].innerHTML  == 8) squares[i].style.backgroundColor = '#f2b179'
    else if (squares[i].innerHTML  == 16) squares[i].style.backgroundColor = '#ffcea4'
    else if (squares[i].innerHTML  == 32) squares[i].style.backgroundColor = '#e8c064'
    else if (squares[i].innerHTML == 64) squares[i].style.backgroundColor = '#ffab6e'
    else if (squares[i].innerHTML == 128) squares[i].style.backgroundColor = '#fd9982'
    else if (squares[i].innerHTML == 256) squares[i].style.backgroundColor = '#ead79c'
    else if (squares[i].innerHTML == 512) squares[i].style.backgroundColor = '#76daff'
    else if (squares[i].innerHTML == 1024) squares[i].style.backgroundColor = '#beeaa5'
    else if (squares[i].innerHTML == 2048) squares[i].style.backgroundColor = '#d7d4f0'
  }
}
addColours()
//control(); 
var myTimer = setInterval(addColours, 50)
  