const quizData = [
    {
        question: "What is the capital of France?",
        options: ["Berlin", "Madrid", "Paris", "Lisbon"],
        answer: "Paris",
    },
    {
        question: "Which language is used for web development?",
        options: ["Python", "HTML", "Java", "C++"],
        answer: "HTML",
    },
    {
        question: "Who wrote 'Hamlet'?",
        options: [
            "Charles Dickens",
            "William Shakespeare",
            "Mark Twain",
            "Jane Austen",
        ],
        answer: "William Shakespeare",
    },
];

var currentQuestion = 0;
var score = 0;
var timeLeft = 30;
var timerInterval;
const timerEl = document.getElementById("time");
const questionEl = document.querySelector(".question");
const optionsEl = document.querySelector(".options");
const resultEl = document.querySelector(".result");
const scoreEl = document.getElementById("score");
const restartBtn = document.querySelector(".restart-btn");
function loadQuestion() {
    if (currentQuestion >= quizData.length) {
        endQuiz();
        return;
    }
    const currentQuiz = quizData[currentQuestion];
    questionEl.textContent = currentQuiz.question;
    optionsEl.innerHTML = "";
    currentQuiz.options.forEach(function(option) {
        const button = document.createElement("button");
        button.classList.add("option");
        button.textContent = option;
        button.onclick = function() { checkAnswer(option)};
        optionsEl.appendChild(button);
    });
}
function checkAnswer(selectedOption) {
    if (selectedOption === quizData[currentQuestion].answer) {
        score++;
    }
    currentQuestion++;
    loadQuestion();
}
function startTimer() {
    timerInterval = setInterval(function() {
        timeLeft--;
        timerEl.textContent = timeLeft;

        if (timeLeft <= 0) {
            endQuiz();
        }
    }, 1000);
}
function endQuiz() {
    clearInterval(timerInterval);
    questionEl.style.display = "none";
    optionsEl.style.display = "none";
    resultEl.style.display = "block";
    scoreEl.textContent = score;
    restartBtn.style.display = "block";
}
restartBtn.addEventListener("click", function() {
    currentQuestion = 0;
    score = 0;
    timeLeft = 30;
    timerEl.textContent = timeLeft;
    questionEl.style.display = "block";
    optionsEl.style.display = "block";
    resultEl.style.display = "none";
    restartBtn.style.display = "none";
    loadQuestion();
    startTimer();
});
loadQuestion();
startTimer();

