"""Class for representing an allocation site"""

from typing import TYPE_CHECKING, Union
from absint_ai.Environment.memory.ConcreteHeap import ConcreteHeap
from absint_ai.Environment.memory.RecordResult import RecordResult
from absint_ai.Environment.memory.StackFrame import StackFrame
from absint_ai.Environment.types.Type import *
from absint_ai.utils.Util import *
from openai import OpenAI
from ordered_set import OrderedSet

if TYPE_CHECKING:
    from absint_ai.Environment.Environment import Environment


class AllocationSite:
    def __init__(
        self,
        allocation_site_type,
        allocation_site: str,
        summary_addresses=None,
        concrete_addresses=None,
        merging_strategies=None,
    ):
        if summary_addresses is None:
            summary_addresses = OrderedSet()
        self.summary_addresses = summary_addresses
        if concrete_addresses is None:
            concrete_addresses = OrderedSet()
        self.concrete_addresses = concrete_addresses
        if merging_strategies is None:
            merging_strategies = {}
        self.merging_strategies = merging_strategies
        self.type = allocation_site_type
        self.allocation_site = allocation_site
        self.readable_allocation_site = self.get_readable_allocation_site()
        self.most_recent_address = None  # Used for recency abstraction
        self.global_merging_strategy = None

    def get_readable_allocation_site(self):
        allocation_site_split = self.allocation_site.split("_")
        if len(allocation_site_split) < 4:
            return self.allocation_site
        start_line = allocation_site_split[-4]
        start_column = allocation_site_split[-3]
        return f"Alloc@L{start_line}C{start_column}"

    def __getitem__(self, key):
        return getattr(self, key)

    def __setitem__(self, key, value):
        setattr(self, key, value)

    def __str__(self):
        if self.readable_allocation_site:
            return self.readable_allocation_site
        else:
            return self.allocation_site
