from abc import ABC, abstractmethod
from typing import Protocol, TYPE_CHECKING
from dataclasses import dataclass

if TYPE_CHECKING:
    from absint_ai.Environment.Environment import (
        Environment,
    )  # Import the class only for type checking
    from absint_ai.Environment.agents.actions import AgentAction


class Agent(ABC):
    @abstractmethod
    def decide_site_selection(
        self,
        env: "Environment",
        changed_allocation_sites: list[str],
    ) -> "AgentAction":
        """Return the next action the agent wants to perform given the current analysis state."""
        pass

    @abstractmethod
    def decide_merging_strategy_for_site(
        self,
        env: "Environment",
        allocation_site: str,
    ) -> "AgentAction":
        """Return the next action the agent wants to perform given the current analysis state."""
        pass

    @abstractmethod
    def decide_widening_strategy_for_site(
        self,
        env: "Environment",
        allocation_site: str,
    ) -> "AgentAction":
        """Return the next action the agent wants to perform given the current analysis state."""
        pass

    @abstractmethod
    def decide_primitives(
        self,
        env: "Environment",
        allocation_site: str,
    ) -> "AgentAction":
        """Return the next action the agent wants to perform given the current analysis state."""
        pass

    @abstractmethod
    def receive_info(self, info: str) -> None:
        """Receive information from the environment."""
        pass
