from .Type import *


class MemoizedFunction:
    def __init__(
        self,
        func: Address,
        function_id: str,
        params: dict[str, list[Type]],
        touched_address_values: dict[Address, object],
        touched_addresses_hash: int,
        touched_primitives: dict[str, list[Type]],
        touched_primitives_hash: int,
        allocated_addresses: list[Address],
        return_values: list[Type],
    ):
        self.func = func
        self.params = params
        self.touched_address_values = touched_address_values
        self.touched_addresses_hash = touched_addresses_hash
        self.touched_primitives = touched_primitives
        self.touched_primitives_hash = touched_primitives_hash
        self.allocated_addresses = allocated_addresses
        self.return_values = return_values
        self.function_id = function_id

    def __eq__(self, other: object) -> bool:
        if not isinstance(other, MemoizedFunction):
            return False
        return (
            self.get_function_id() == other.get_function_id()
            and self.params == other.params
            and self.return_values == other.return_values
            and self.touched_address_values == other.touched_address_values
            and self.touched_addresses_hash == other.touched_addresses_hash
            and self.touched_primitives == other.touched_primitives
            and self.touched_primitives_hash == other.touched_primitives_hash
            and self.allocated_addresses == other.allocated_addresses
        )

    def get_params(self) -> dict[str, list[Type]]:
        return self.params

    def is_recursive_call(self) -> bool:
        return self.return_values is None

    def get_touched_address_values(self) -> dict[Address, object]:
        return self.touched_address_values

    def get_touched_addresses_hash(self) -> int:
        return self.touched_addresses_hash

    def get_touched_primitives(self) -> dict[str, list[Type]]:
        return self.touched_primitives

    def get_touched_primitives_hash(self) -> int:
        return self.touched_primitives_hash

    def get_allocated_addresses(self) -> list[Address]:
        return self.allocated_addresses

    def get_return_values(self) -> list[Type]:
        return self.return_values

    def get_function_id(self) -> str:
        return self.function_id

    def __str__(self) -> str:
        return (
            f"MemoizedFunction: {self.function_id} {self.params} {self.return_values}"
        )

    def __repr__(self) -> str:
        return (
            f"MemoizedFunction: {self.function_id} {self.params} {self.return_values}"
        )

    def __hash__(self) -> int:
        return hash(f"{self.function_id} {self.params}")

    def __deepcopy__(self, memo: object) -> Self:
        return MemoizedFunction(  # type: ignore
            self.func,
            self.params,
            self.touched_address_values,
            self.touched_addresses_hash,
            self.touched_primitives,
            self.touched_primitives_hash,
            self.allocated_addresses,
            self.return_values,
        )
