from enum import Enum
import esprima
from typing_extensions import Self
from abc import ABC, abstractmethod
from absint_ai.utils.Logger import logger

global function_id
function_id = 0


class Type(ABC):
    def __init__(self) -> None:
        self.parent_heap_frame = None

    def set_parent_heap_frame(self, parent_heap_frame: object) -> None:
        self.parent_heap_frame = parent_heap_frame  # type: ignore

    def get_parent_heap_frame(self) -> object:
        return self.parent_heap_frame

    @abstractmethod
    def get_value(self) -> object:
        pass

    @abstractmethod
    def __str__(self) -> str:
        pass

    @abstractmethod
    def __repr__(self) -> str:
        pass

    @abstractmethod
    def __eq__(self, other: object) -> bool:
        pass

    @abstractmethod
    def __hash__(self) -> int:
        pass


class Primitive(Type):
    def __init__(self, value: int | float | str | bool, is_regex: bool = False):
        self.value = value
        if isinstance(value, int):
            self.type = baseType.NUMBER
        elif isinstance(value, float):
            self.type = baseType.NUMBER
        elif isinstance(value, str):
            self.type = baseType.STRING
        elif isinstance(value, bool):
            self.type = baseType.BOOLEAN
        self.is_regex = is_regex

        super().__init__()

    def get_value(self) -> int | float | str | bool:
        return self.value

    def __str__(self) -> str:
        return f"Primitive({self.value})"

    def __repr__(self) -> str:
        return f"Primitive({self.value})"

    def __eq__(self, other: object) -> bool:
        if not isinstance(other, Primitive):
            return False
        return self.value == other.value

    def __hash__(self) -> int:
        return hash(self.value)


class Address(Type):
    def __init__(self, value: str, addr_type: str):
        self.value = value
        if addr_type != "concrete" and addr_type != "abstract":
            raise ValueError(f"Address type must be either 'concrete' or 'abstract'")
        self.addr_type = addr_type
        super().__init__()

    def get_value(self) -> str:
        return self.value

    def set_value(self, value: str) -> None:
        # logger.info(f"Setting value of address {self} to {value}")
        self.value = value

    def get_addr_type(self) -> str:
        return self.addr_type

    def toJSON(self):
        if self.addr_type == "abstract":
            return f"Abstract Address({self.value})"
        else:
            return f"Concrete Address({self.value})"

    def set_addr_type(self, addr_type: str) -> None:
        if addr_type != "concrete" and addr_type != "abstract":
            raise ValueError(f"Address type must be either 'concrete' or 'abstract'")
        # logger.info(f"Setting address type of address {self} to {addr_type}")
        self.addr_type = addr_type

    def __str__(self) -> str:
        if self.addr_type == "concrete":
            return f"Concrete Address({self.value})"
        elif self.addr_type == "abstract":
            return f"Abstract Address({self.value})"
        else:
            raise ValueError(f"Address type must be either 'concrete' or 'abstract'")

    def __repr__(self) -> str:
        if self.addr_type == "concrete":
            return f"Concrete Address({self.value})"
        elif self.addr_type == "abstract":
            return f"Abstract Address({self.value})"
        else:
            raise ValueError(f"Address type must be either 'concrete' or 'abstract'")

    def __eq__(self, other: object) -> bool:
        if not isinstance(other, Address):
            return False
        return self.value == other.value and self.addr_type == other.addr_type

    def __hash__(self) -> int:
        return hash(f"{self.addr_type} {self.value}")


class AbstractType(Type):
    def __init__(self, cls: str):
        self.cls = cls
        super().__init__()

    def get_cls(self) -> str:
        return self.cls

    def get_value(self) -> str:
        return self.cls

    def __str__(self) -> str:
        return f"{self.cls}"

    def __repr__(self) -> str:
        return f"{self.cls}"

    def __eq__(self, other: object) -> bool:
        if not isinstance(other, AbstractType):
            return False
        return self.cls == other.cls

    def __hash__(self) -> int:
        return hash(self.cls)


class baseType:
    NULL: Type = AbstractType("NULL")
    TOP: Type = AbstractType("TOP")
    STRING: Type = AbstractType("STRING")
    NUMBER: Type = AbstractType("NUMBER")
    BOOLEAN: Type = AbstractType("BOOL")
    RECURSIVE_PLACEHOLDER: Type = AbstractType("RECURSIVE_PLACEHOLDER")
