const espree =require("espree")
const fs = require("fs")
const esrefactor = require("esrefactor")
var eslintScope = require('eslint-scope');
const objectHash = require('object-hash');
var estraverse = require('estraverse');

if (process.argv.length > 2 && process.argv[3] === "-s") {
    var source_type = "script";
} else {
    var source_type = "module";
}

function replaceAssignmentOperator(ast) {
    return estraverse.replace(ast, {
        enter: function (node) {
            // Replace it with replaced.
            if (node.type === 'AssignmentExpression') {
                var needs_rewrite = false;
                if (node.operator === '+=') {
                    var operator = '+'
                    needs_rewrite = true;
                }
                else if (node.operator === '-=') {
                    var operator = '-'
                    needs_rewrite = true;
                }
                else if (node.operator === '*=') {
                    var operator = '*'
                    needs_rewrite = true;
                }
                else if (node.operator === '/=') {
                    var operator = '/'
                    needs_rewrite = true;
                }
                else if (node.operator === '%=') {
                    var operator = '%'
                    needs_rewrite = true;
                }
                else if (node.operator === '<<=') {
                    var operator = '<<'
                    needs_rewrite = true;
                }
                else if (node.operator === '>>=') {
                    var operator = '>>'
                    needs_rewrite = true;
                }
                else if (node.operator === '>>>=') {
                    var operator = '>>>'
                    needs_rewrite = true;
                }
                else if (node.operator === '&=') {
                    var operator = '&'
                    needs_rewrite = true;
                }
                else if (node.operator === '|=') {
                    var operator = '|'
                    needs_rewrite = true;
                }
                else if (node.operator === '^=') {
                    var operator = '^'
                    needs_rewrite = true;
                }
                if (needs_rewrite) {
                    return {
                        type: 'AssignmentExpression',
                        operator: '=',
                        left: node.left,
                        right: {
                            type: 'BinaryExpression',
                            operator: operator,
                            left: node.left,
                            right: node.right,
                            loc: {
                                start: node.left.loc.end,
                                end: node.right.loc.end
                            },
                            range: [node.left.range[1], node.right.range[1]]
                        },
                        loc: node.loc,
                        range: node.range
                    };
                }
             } 
            
            
        }
    });
}

function getAST(filepath) {
    code = fs.readFileSync(filepath, "utf-8");

    var ast = espree.parse(code,{ecmaVersion: "latest", sourceType:source_type,range:true,loc:true});
    ast = replaceAssignmentOperator(ast);
    return JSON.stringify(ast,(key, value) =>
        typeof value === "bigint" ? Number(value) : value, 4);
}

function path_underscored(path) {
    return path.replaceAll("/","_")
}

function scopeToId(filepath, scope) {
    if (scope === null) {
        return null;
    }
    var filepath_underscored = path_underscored(filepath);
    //return `${scope.block.loc.start.line}_${scope.block.loc.start.column}_${scope.block.loc.end.line}_${scope.block.loc.end.column}`;
    return `${filepath_underscored}_${scope.block.loc.start.line}_${scope.block.loc.end.line}_${scope.block.loc.end.column}_${scope.type}`;
}

function generateScopeSchema(filepath) {
    var result = {}
    code = fs.readFileSync(filepath, "utf-8");
    var ast = espree.parse(code,{ecmaVersion: 14, sourceType:source_type,range:true,loc:true});
    ast = replaceAssignmentOperator(ast);
    const scopeManager = eslintScope.analyze(ast, {ecmaVersion: 14, sourceType:source_type});
    /*
    for (const variable of scopeManager.globalScope.variables) {
        console.log("Global definition:", variable.name);
        console.log("   References:");
        for (const ref of variable.references) {
            if (ref.resolved) {
                console.log("   Reference:", ref.identifier.name, " from scope:", ref.resolved.scope.type);
            }
            else {
                console.log("   Reference:", ref.identifier.name, " from scope: <unresolved> ");
            }
        }
    }
        */
    
    var globalPrivateVars = scopeManager.globalScope.variables.map((variable) => variable.name);
    var globalSharedVars = [];
    for (const scope of scopeManager.scopes) {
        if (scope.type === "global") {
            continue;
        }
        var scopeId = scopeToId(filepath, scope);
        var scopeResult = {"private_vars": [], "shared_vars": [], "parent": scopeToId(filepath, scope.upper), "type": scope.type};
        if (scope.type === "module") {
            scopeResult["parent"] = "global";
            scopeId = `${path_underscored(filepath)}_module`;
        }
        /*
        else if (scope.type === "for") {
            scopeId = `${scopeId}_for`;
        } 
        else if (scope.type === "block") {
            if (scope.upper.type === "for") {
                scopeResult["parent"] = `${scopeToId(filepath, scope.upper)}`;
            }
        }
        */
        for (const ref of scope.references) {
            if (!ref.resolved && globalPrivateVars.includes(ref.identifier.name)) {
                globalSharedVars.push(ref.identifier.name);
                const indexToRemove = globalPrivateVars.indexOf(ref.identifier.name);
                globalPrivateVars.splice(indexToRemove, 1);
            }

        }
        for (const variable of scope.variables) {
            found_shared = false;
            for (const ref of variable.references) {
                //console.log("   Reference:", ref.identifier.name, " from scope:", ref.from.type, " at node:", ref.from.block.loc.start);
                if ((ref.from.block.loc.start !== scope.block.loc.start) || (ref.from.block.loc.end !== scope.block.loc.end)) {
                    found_shared = true;
                    if (!scopeResult.shared_vars.includes(variable.name)) {
                        scopeResult.shared_vars.push(variable.name);
                    }
                } 
            }
            if (!found_shared) {
                if (!scopeResult.private_vars.includes(variable.name)) {
                    scopeResult.private_vars.push(variable.name);
                }
            }
        }
        result[scopeId] = scopeResult;
        //console.log("Scope:", scope.type, " at node:", scope.block.loc.end, scopeResult);
    }
    globalScopeResult = {"private_vars": globalPrivateVars, "shared_vars": globalSharedVars, "parent": null, "type": "global"};
    result["global"] = globalScopeResult;
    return JSON.stringify(result, null, 4);
}

console.log(getAST(process.argv[2]));
console.log("#".repeat(50));
console.log(generateScopeSchema(process.argv[2]));