import pythonmonkey as pm
from ordered_set import OrderedSet

# import the util the next line
import absint_ai.utils.Util as util
from absint_ai.Environment.types.Type import *
import itertools
from typing import TYPE_CHECKING
import json

if TYPE_CHECKING:
    from absint_ai.Environment.Environment import Environment


# Each argument is a list of possibleValues
def execute_string_builtin(
    string: str,
    method: str,
    arguments_as_types: list[OrderedSet[Type]],
    env: "Environment",
) -> OrderedSet[Type]:
    """
    Executes a string method with the given arguments.
    """
    if string == "STRING":
        return OrderedSet([return_for_abstract_type(method)])
    results = OrderedSet()
    arguments_as_values = [
        [util.type_to_value(arg, env) for arg in argument]
        for argument in arguments_as_types
    ]
    abstract_values = ["NUMBER", "STRING", "BOOLEAN"]
    all_possible_values = list(itertools.product(*arguments_as_values))
    for values in all_possible_values:
        # check if there's an abstract value in the values
        if any(str(value) in abstract_values for value in values):
            results.add(return_for_abstract_type(method))
            continue
        values_comma_separated = ", ".join(
            [
                (
                    util.escape_string(f"'{str(value)}'")
                    if (isinstance(value, str) and not value.startswith("@REGEX:"))
                    else str(value).replace("@REGEX:", "")
                )
                for value in values
            ]
        )
        string_to_execute = util.escape_string(
            f'"{string}".{method}({values_comma_separated})'
        )
        logger.info(f"string to execute: {string_to_execute}")
        try:
            result_as_value = pm.eval(string_to_execute)
            if result_as_value == pm.null:
                result_as_value = None
            result_as_type = util.value_to_type(result_as_value, env)
            results.add(result_as_type)
        except Exception:
            continue
    logger.info(f"Executing string method: {string_to_execute}. result is {results}")
    return results


def return_for_abstract_type(method: str) -> Type:
    """
    Returns the appropriate type for the given method.
    """
    if method == "length":
        return baseType.NUMBER
    elif method == "charAt":
        return baseType.STRING
    elif method == "charCodeAt":
        return baseType.NUMBER
    elif method == "concat":
        return baseType.STRING
    elif method == "indexOf":
        return baseType.NUMBER
    elif method == "lastIndexOf":
        return baseType.NUMBER
    elif method == "localeCompare":
        return baseType.NUMBER
    elif method == "match":
        return baseType.STRING
    elif method == "replace":
        return baseType.STRING
    elif method == "search":
        return baseType.NUMBER
    elif method == "at":
        return baseType.STRING
    elif method == "slice":
        return baseType.STRING
    elif method == "substring":
        return baseType.STRING
    else:
        raise Exception(f"Unknown method: {method}")
