# type: ignore
import logging
import re
import sty
import os
from datetime import datetime

logger = logging.getLogger(__name__)
#logging.disable(logging.CRITICAL)
logger.setLevel(logging.DEBUG)  # Set the desired logging level


dt = datetime.now().strftime("%m_%d_%H_%M")

# Create a formatter and set it for the handler
formatter = logging.Formatter("[%(filename)s:%(funcName)s:%(lineno)d]: %(message)s")


# Add the handler to the logger
def set_file_handler(file_name):
    file_handler = logging.FileHandler(f"/tmp/log_{dt}_{file_name}.txt", mode="w")
    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(formatter)
    logger.addHandler(file_handler)


def set_console_handler():
    console_handler = logging.StreamHandler()
    console_handler.setLevel(logging.DEBUG)
    console_handler.setFormatter(formatter)
    logger.addHandler(console_handler)

