import os
import sys
from absint_ai.Interpreter import AbsIntAI
from absint_ai.utils.Util import *
import json
from absint_ai.utils.Logger import logger
from datetime import datetime
import argparse
import debugpy
import socket


dt = datetime.now().strftime("%m_%d_%H_%M")
# parse arguments
parser = argparse.ArgumentParser(description="Run the nullcheck analysis")
parser.add_argument("script", type=str, help="The script to analyze")
parser.add_argument(
    "--simplify_method",
    type=str,
    default="file",
    help="The method to simplify the script",
)

parser.add_argument("--visualize", action="store_true", help="Visualize the output")
parser.add_argument(
    "--visualize_abstraction", action="store_true", help="Visualize the abstractions"
)
parser.add_argument(
    "--no_abstract",
    action="store_true",
    help="Do not perform abstractions",
    default=False,
)
parser.add_argument(
    "--model", type=str, default="Llama-3.3-70B-Instruct", help="The model to use"
)
parser.add_argument("--port", type=int, default=8000, help="The port to run the server")
parser.add_argument(
    "--openai", action="store_true", help="Use OpenAI API", default=False
)
parser.add_argument(
    "-v", "--verbose", action="store_true", help="Verbose output", default=False
)
parser.add_argument(
    "--check_pointers", action="store_true", default=False, help="Check pointers"
)
parser.add_argument(
    "--debug",
    action="store_true",
    help="Debug the code",
    default=False,
)
parser.add_argument("--loop_max", type=int, default=10, help="Max number of loops")
parser.add_argument(
    "--single_iteration",
    action="store_true",
    default=False,
    help="run only a single iteration",
)

parser.add_argument(
    "--store_identifier_info",
    action="store_true",
    default=False,
    help="store identifier info to /tmp/identifier_info.json",
)
args = parser.parse_args()
if args.openai:
    api_key = os.environ["OPENAI_API_KEY"]
if args.simplify_method == "llm":
    model = args.model  # "meta-llama/Llama-3.3-70B-Instruct"
    # model="01-ai/Yi-Coder-9B-Chat",
    # model="codellama/CodeLlama-34b-Instruct-hf",
    check = AbsIntAI.AbsIntAI(
        global_simplify_method="llm",
        simplify_method="llm",
        model=model,
        log_console=args.verbose,
        check_pointers=args.check_pointers,
        loop_max=args.loop_max,
        timeout=99999999999999999999,
    )
    if args.openai:
        check.initialize_openai(openai_key=api_key, base_url=None)
    else:
        check.initialize_openai("EMPTY", f"http://localhost:{args.port}/v1")
elif args.simplify_method == "allocation_sites":
    with open(args.script, "r") as f:
        scriptContents = f.read()
    check = AbsIntAI.AbsIntAI(
        simplify_method="allocation_sites",
        should_abstract=not args.no_abstract,
        check_pointers=args.check_pointers,
        log_console=args.verbose,
        timeout=99999999999999999999,
        loop_max=args.loop_max,
    )
elif args.simplify_method == "recency":
    with open(args.script, "r") as f:
        scriptContents = f.read()
    check = AbsIntAI.AbsIntAI(
        simplify_method="recency",
        global_simplify_method="recency",
        should_abstract=not args.no_abstract,
        check_pointers=args.check_pointers,
        log_console=args.verbose,
        timeout=99999999999999999999,
        loop_max=args.loop_max,
    )
elif args.simplify_method == "depth":
    with open(args.script, "r") as f:
        scriptContents = f.read()
    check = AbsIntAI.AbsIntAI(
        simplify_method="depth",
        global_simplify_method="depth",
        should_abstract=not args.no_abstract,
        check_pointers=args.check_pointers,
        log_console=args.verbose,
        timeout=99999999999999999999,
        loop_max=args.loop_max,
    )
elif args.simplify_method == "llm_naive":
    model = args.model  # "meta-llama/Llama-3.3-70B-Instruct"
    check = AbsIntAI.AbsIntAI(
        global_simplify_method="llm_naive",
        simplify_method="llm_naive",
        file_name=args.script,
        log_console=args.verbose,
        model=model,
        check_pointers=args.check_pointers,
    )
    if args.openai:
        check.initialize_openai(openai_key=api_key, base_url=None)
    else:
        check.initialize_openai("EMPTY", f"http://localhost:{args.port}/v1")
elif args.simplify_method == "manual":
    with open(args.script, "r") as f:
        scriptContents = f.read()
    check = AbsIntAI.AbsIntAI(
        simplify_method="manual",  # TODO Keep this as allocation sites for now
        global_simplify_method="manual",
        should_abstract=not args.no_abstract,
        check_pointers=args.check_pointers,
        loop_max=args.loop_max,
    )
else:
    print("Invalid simplify method")
    sys.exit(1)

if args.no_abstract:
    check.loop_max = 1

if args.single_iteration:
    check.set_test_mode()
check.should_visualize = args.visualize
check.should_visualize_abstraction = args.visualize_abstraction
# check.keep_looping = args.visualize
check.log_lines_run = True
check.should_profile = False

if args.debug:
    check.debug = True
    debugpy.listen(5678)
    print("Waiting for debugger attach...")
    debugpy.wait_for_client()
    debugpy.breakpoint()
env = check.run(os.path.abspath(args.script))
if args.store_identifier_info:
    with open("/tmp/identifier_info.json", "w") as f:
        f.write(json.dumps(check.identifier_info, indent=4, cls=AbsIntAIEncoder))
# print(
#    json.dumps(check.identifier_info, indent=4, cls=AbsIntAIEncoder)
# )  # env.pretty_print_all_variables())
print(env.pretty_print_all_variables())
# print(f"The final state is:")
# print(env.pretty_print_all_variables())
# print("THE CONCRETE HEAP IS:")
# print(env.pretty_print_concrete_heap())
# print("THE ABSTRACT HEAP IS:")
# print(env.pretty_print_abstract_heap())
# print("THE BUGGY LINES ARE:")
# print(json.dumps(list(set(check.buggy_lines)), indent=4))
# buggy_lines_str = "\n".join(list(set(check.buggy_lines)))
buggy_line_numbers_str = "\n".join(list(set(check.buggy_lines)))
print(buggy_line_numbers_str)
print(f"There are {len(list(set(check.buggy_line_numbers)))} possible buggy lines")
# check.visualize(f"{buggy_lines_str}", "FINISHED!")
# logger.info(f"There are {len(list(set(check.buggy_line_numbers)))} possible buggy lines")
# logger.info(f"Total lines executed: {check.executed_lines}")
# logger.info(f"Simplify calls: {check.simplify_calls}")
# logger.info(f"Number of loops: {check.num_loops}")
# logger.info(f"Number of object accesses: {check.obj_accesses}")
# logger.info(f"Number of correct accesses: {check.correct_accesses}")
# logger.info(f"Size of the concrete heap: {len(env.concrete_heap.concrete_heap)}")
# logger.info(f"Size of the abstract heap: {len(env.abstract_heap.abstract_heap)}")
# logger.info(f"Number of array builtins called: {check.called_builtins_count}")
# with open(f"/tmp/bugs_{dt}.txt", "w") as f:
#    f.write(buggy_lines_str)
# print(json.dumps(env.to_json_schema(), indent=4))
# with open("/tmp/schema.json", "w") as f:
#    f.write(json.dumps(env.to_json_schema(), indent=4))
# check.visualize()
# env.pretty_print()
# env.pretty_print()
# except Exception as e:
#    print("Exception: ", e)
