import unittest
import unittest.mock
from absint_ai.Interpreter import AbsIntAI
from absint_ai.utils.Logger import logger
from absint_ai.Environment.Environment import Environment
from absint_ai.Environment.types.Type import *
from absint_ai.Environment.memory.ConcreteHeap import *
from absint_ai.Environment.memory.AbstractHeap import *
from absint_ai.utils.Util import *
import os


class TestSmallBenchmarks(unittest.TestCase):
    def setUp(self):
        self.testLLM = False
        self.base_class = "../benchmarks/small"

    def test_crossword(self):
        check = AbsIntAI.AbsIntAI()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "crossword.js"
        )
        env = check.run(scriptPath)

    def test_custom_countdown(self):
        check = AbsIntAI.AbsIntAI()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "custom_countdown.js"
        )
        env = check.run(scriptPath)

    def test_expense_tracker(self):
        check = AbsIntAI.AbsIntAI()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "expense_tracker.js"
        )
        env = check.run(scriptPath)

    def test_memory_puzzle(self):
        check = AbsIntAI.AbsIntAI()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "memory_puzzle.js"
        )
        env = check.run(scriptPath)

    def test_snake_game(self):
        check = AbsIntAI.AbsIntAI()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "snake_game.js"
        )
        env = check.run(scriptPath)


class testMediumBenchmarks(unittest.TestCase):
    def setUp(self):
        self.testLLM = False
        self.base_class = "../benchmarks/medium/"
