import unittest
import unittest.mock
from absint_ai.Interpreter import AbsIntAI
from absint_ai.utils.Logger import logger
from absint_ai.Environment.Environment import Environment
from absint_ai.Environment.types.Type import *
from absint_ai.Environment.memory.ConcreteHeap import *
from absint_ai.Environment.memory.AbstractHeap import *
from absint_ai.utils.Util import *
import os


class testBuiltins(unittest.TestCase):
    def setUp(self):
        self.testLLM = False
        self.base_class = "js_files/builtins"

    def test_document_get_element_by_id(self):
        check = AbsIntAI.AbsIntAI()
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__),
            self.base_class,
            "document",
            "document_get_element_by_id.js",
        )
        env = check.run(scriptPath)
        logger.info(env.lookup_and_derive("test"))
        # self.assertEqual(["STRING"], env.lookup_and_derive("test"))

    def test_event_listener(self):
        check = AbsIntAI.AbsIntAI()
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__),
            self.base_class,
            "document",
            "event_listener.js",
        )
        env = check.run(scriptPath)
        logger.info(f"test is {env.lookup_and_derive('global_obj')}")
        # self.assertEqual([{"clicked": [True]}], env.lookup_and_derive("global_obj"))


class testArrayBuiltins(unittest.TestCase):
    def setUp(self):
        self.testLLM = False
        self.base_class = "js_files/builtins/arrays"

    def test_array_push(self):
        check = AbsIntAI.AbsIntAI()
        # self.assertEqual(True, False)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "array_push.js"
        )
        env = check.run(scriptPath)
        self.assertEqual(
            [{0: [1], 1: [2], 2: [3], 3: [4], 4: [5], 5: [6], 6: [7]}],
            env.lookup_and_derive("a"),
        )

    def test_join(self):
        check = AbsIntAI.AbsIntAI()
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "array_join.js"
        )
        env = check.run(scriptPath)
        self.assertEqual(["Fire,Air,Water"], env.lookup_and_derive("result1"))
        self.assertEqual(["FireAirWater"], env.lookup_and_derive("result2"))
        self.assertEqual(["Fire-Air-Water"], env.lookup_and_derive("result3"))

    def test_array_constructor(self):
        check = AbsIntAI.AbsIntAI()
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "array_constructor.js"
        )
        env = check.run(scriptPath)
        self.assertEqual(
            [{0: ["NULL"], 1: ["NULL"], 2: ["NULL"]}], env.lookup_and_derive("arr1")
        )
        self.assertEqual([{0: [1], 1: [2], 2: [3]}], env.lookup_and_derive("arr2"))
        self.assertEqual(
            [{0: [{"0": [1.0], "1": [2.0], "2": [3.0]}]}], env.lookup_and_derive("arr3")
        )


class testStringBuiltins(unittest.TestCase):
    def setUp(self):
        self.testLLM = False
        self.base_class = "js_files/builtins/strings"

    def test_split(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "split.js"
        )
        env = check.run(scriptPath)
        logger.info(env.lookup_and_derive("result"))
        self.assertEqual(
            [{0: ["foo"], 1: ["bar"], 2: ["baz"]}], env.lookup_and_derive("result")
        )

    def test_charAt(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "charAt.js"
        )
        env = check.run(scriptPath)
        self.assertEqual(["T"], env.lookup_and_derive("first"))
        self.assertEqual(["E"], env.lookup_and_derive("second"))

    def test_concat(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "concat.js"
        )
        env = check.run(scriptPath)
        self.assertEqual(["Hello World"], env.lookup_and_derive("result1"))
        self.assertEqual(["World, Hello"], env.lookup_and_derive("result2"))

    def test_indexOf(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "indexOf.js"
        )
        env = check.run(scriptPath)
        self.assertEqual([2], env.lookup_and_derive("result1"))
        self.assertEqual([-1], env.lookup_and_derive("result2"))

    def test_charCodeAt(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "charCodeAt.js"
        )
        env = check.run(scriptPath)
        self.assertEqual([76], env.lookup_and_derive("result"))

    def test_includes(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "includes.js"
        )
        env = check.run(scriptPath)
        self.assertEqual([True], env.lookup_and_derive("result1"))
        self.assertEqual([False], env.lookup_and_derive("result2"))
        self.assertEqual([True], env.lookup_and_derive("result3"))
        self.assertEqual([False], env.lookup_and_derive("result4"))

    def test_fromCharCode(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "fromCharCode.js"
        )
        env = check.run(scriptPath)
        self.assertEqual(["HELLO"], env.lookup_and_derive("text"))

    def test_search(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "search.js"
        )
        env = check.run(scriptPath)
        self.assertEqual([6], env.lookup_and_derive("result1"))
        self.assertEqual([-1], env.lookup_and_derive("result2"))
        self.assertEqual([6], env.lookup_and_derive("result3"))
        self.assertEqual([3], env.lookup_and_derive("result4"))
        self.assertEqual([2], env.lookup_and_derive("result5"))
        self.assertEqual([-1], env.lookup_and_derive("result6"))

    def test_substring(self):
        check = AbsIntAI.AbsIntAI(log_console=True)
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "substring.js"
        )
        env = check.run(scriptPath)
        self.assertEqual(
            ["dog = draw('bluedog1',9.74,6.73,10)"], env.lookup_and_derive("result")
        )


if __name__ == "__main__":
    unittest.main(buffer=False)
