import unittest
import unittest.mock
from absint_ai.Interpreter import AbsIntAI
from absint_ai.utils.Logger import logger
from absint_ai.Environment.Environment import Environment
from absint_ai.Environment.types.Type import *
from absint_ai.Environment.memory.ConcreteHeap import *
from absint_ai.Environment.memory.AbstractHeap import *
from absint_ai.utils.Util import *
import os


class testLLMAbstractions(unittest.TestCase):
    def setUp(self):
        self.testLLM = True
        self.run = False
        self.base_class = "js_files/llm_abstractions"
        self.base_url = "http://localhost:8000/v1"
        self.api_key = "EMPTY"
        # self.model = "codellama/CodeLlama-34b-Instruct-hf"
        self.model = "01-ai/Yi-Coder-9B-Chat"

    def run_multiple_iterations(self, num_iters, filepath):
        buggy_lines = []
        for i in range(num_iters):
            check = AbsIntAI.AbsIntAI(
                simplify_method="llm",
                file_name=os.path.join(os.path.dirname(__file__), filepath),
                model=self.model,
            )
            check.initialize_openai(self.api_key, self.base_url)
            scriptName = os.path.join(os.path.dirname(__file__), filepath)
            env = check.run(scriptName)
            buggy_lines.append(check.buggy_lines)
        # get the intersection of the buggy lines
        # buggy_lines = list(set.intersection(*map(set, buggy_lines)))
        return buggy_lines

    def test_simplest_loop(self):
        if not self.run:
            return
        check = AbsIntAI.AbsIntAI(simplify_method="llm", model=self.model)
        check.initialize_openai(self.api_key, self.base_url)
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "simplest_loop.js"
        )
        env = check.run(scriptPath)
        self.assertEqual(env.lookup_and_derive("acc"), ["NUMBER"])

    def test_simplest_while_loop(self):
        if not self.run:
            return
        check = AbsIntAI.AbsIntAI(simplify_method="llm", model=self.model)
        check.initialize_openai(self.api_key, self.base_url)
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "simplest_while_loop.js"
        )
        env = check.run(scriptPath)
        self.assertTrue("NUMBER" in env.lookup_and_derive("acc"))

    def test_simple_for_key_merge_abstraction_llm(self):
        if not self.run:
            return
        buggy_lines = []
        found_bug = False
        for i in range(3):
            logger.info(f"ITERATION {i} of looking for bug with LLM")
            check = AbsIntAI.AbsIntAI(
                simplify_method="llm",
                model=self.model,
            )
            check.initialize_openai(self.api_key, self.base_url)
            scriptPath = os.path.join(
                os.path.dirname(__file__), "js_files/bugs/simple_loop_key_merge.js"
            )
            env = check.run(scriptPath)
            buggy_lines.append(check.buggy_lines)
            logger.info(f"THERE ARE {len(check.buggy_lines)} BUGGY LINES")
            logger.info(f"the buggy lines are: {check.buggy_lines}")
            for buggy_line in check.buggy_lines:
                if "line 7" in buggy_line:
                    found_bug = True
                    break

        # get the intersection of the buggy lines
        self.assertTrue(found_bug)

    def test_simple_while_bug_abstraction(self):
        if not self.run:
            return
        concrete_heap_id_reset()
        abstract_heap_id_reset()
        check = AbsIntAI.AbsIntAI(simplify_method="llm", model=self.model)
        check.initialize_openai(self.api_key, self.base_url)
        scriptPath = os.path.join(
            os.path.dirname(__file__), "js_files/bugs/simple_while_loop_bug.js"
        )
        env = check.run(scriptPath)
        self.assertTrue(any(["line 13" in _ for _ in check.buggy_lines]))

    def test_long_program(self):
        if not self.run:
            return
        check = AbsIntAI.AbsIntAI(simplify_method="llm", model=self.model)
        check.initialize_openai(self.api_key, self.base_url)
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "long_program.js"
        )
        env = check.run(scriptPath)

    def test_fibonacci_llm(
        self,
    ):  # don't run this test every time since it costs money
        return
        buggy_lines = self.run_multiple_iterations(
            3, "js_files/algorithms/fibonacci.js"
        )

        # self.assertTrue("foo not found in object fibResult at line 23" in buggy_lines)

    def test_simple_for_abstraction_llm(
        self,
    ):  # don't run this test every time since it costs money
        if not self.run:
            return
        buggy_lines = []
        lines = self.run_multiple_iterations(1, "js_files/loops/simple_loop.js")
        scriptPath = os.path.join(
            os.path.dirname(__file__), "js_files/loops/simple_loop.js"
        )
        # self.assertEqual(env.lookup_and_derive("i"), ["NUMBER"])
        # self.assertEqual(env.lookup_and_derive("n"), ["TOP"])
        # env = check.run(scriptPath)


if __name__ == "__main__":
    unittest.main()
