import unittest
import unittest.mock
from absint_ai.Interpreter import AbsIntAI
from absint_ai.utils.Logger import logger
from absint_ai.Environment.Environment import Environment
from absint_ai.Environment.types.Type import *
from absint_ai.Environment.memory.ConcreteHeap import *
from absint_ai.Environment.memory.AbstractHeap import *
from absint_ai.utils.Util import *
import os


class testPathSensitivity(unittest.TestCase):
    def setUp(self):
        self.testLLM = False
        self.base_class = "js_files/path_sensitivity"

    def test_simple_primitive(self):
        check = AbsIntAI.AbsIntAI(simplify_method="allocation_sites")
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "simple_primitive.js"
        )
        env = check.run(scriptPath)
        # self.assertEqual(env.lookup_and_derive("result"), ["initial", "bar"])
        logger.info(set(check.buggy_line_numbers))
        # self.assertEqual(len(set(check.buggy_line_numbers)), 0)
        # self.assertEqual(env.lookup_and_derive("i"), [1, 0, 2, 3])

    def test_obj_update(self):
        check = AbsIntAI.AbsIntAI(simplify_method="allocation_sites")
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "obj_update.js"
        )
        env = check.run(scriptPath)
        # self.assertEqual(len(set(check.buggy_line_numbers)), 0)
        # self.assertEqual(env.lookup_and_derive("obj2"), [{"key1": ["value1"]}])

    def test_objects(self):
        check = AbsIntAI.AbsIntAI(simplify_method="allocation_sites")
        check.set_test_mode()
        scriptPath = os.path.join(
            os.path.dirname(__file__), self.base_class, "objects.js"
        )
        env = check.run(scriptPath)
        # self.assertEqual(len(set(check.buggy_line_numbers)), 0)
