#!/usr/bin/env python3

import os
import sys
from scene import Scene
from gaussian_renderer import GaussianModel
from arguments import ModelParams, PipelineParams, get_combined_args
from argparse import ArgumentParser

def test_camera_loading():
    """测试相机加载功能"""
    
    # 设置参数
    parser = ArgumentParser(description="Camera loading test")
    model = ModelParams(parser, sentinel=True)
    pipeline = PipelineParams(parser)
    parser.add_argument("--iteration", default=-1, type=int)
    
    # 使用相同的参数
    sys.argv = [
        'test_camera_debug.py',
        '-s', '/mnt/f/gihubfile/FlexiGaussian/data/teatime',
        '-m', '/mnt/f/gihubfile/FlexiGaussian/data/pretrain/lerf_ovs/teatime',
        '-i', '30000'
    ]
    
    args = get_combined_args(parser)
    
    print("=== 相机加载测试 ===")
    print(f"数据集路径: {args.source_path}")
    print(f"模型路径: {args.model_path}")
    print(f"迭代次数: {args.iteration}")
    
    # 初始化
    print("\n1. 初始化高斯模型...")
    gaussians = GaussianModel(model.extract(args).sh_degree)
    
    print("2. 初始化场景...")
    scene = Scene(model.extract(args), gaussians, load_iteration=args.iteration, shuffle=False)
    
    print("3. 检查Scene对象...")
    print(f"Scene类型: {type(scene)}")
    print(f"Scene属性: {[attr for attr in dir(scene) if not attr.startswith('_')]}")
    
    # 检查相机属性
    print("\n4. 检查相机属性...")
    if hasattr(scene, 'train_cameras'):
        print(f"train_cameras属性存在: {scene.train_cameras is not None}")
        if scene.train_cameras is not None:
            print(f"train_cameras类型: {type(scene.train_cameras)}")
            print(f"train_cameras长度: {len(scene.train_cameras)}")
            print(f"train_cameras内容: {scene.train_cameras}")
            if len(scene.train_cameras) > 0:
                try:
                    print(f"第一个训练相机: {scene.train_cameras[0].image_name}")
                except Exception as e:
                    print(f"访问第一个训练相机时出错: {e}")
                    print(f"第一个元素类型: {type(scene.train_cameras[0])}")
    else:
        print("train_cameras属性不存在")
    
    if hasattr(scene, 'test_cameras'):
        print(f"test_cameras属性存在: {scene.test_cameras is not None}")
        if scene.test_cameras is not None:
            print(f"test_cameras类型: {type(scene.test_cameras)}")
            print(f"test_cameras长度: {len(scene.test_cameras)}")
            print(f"test_cameras内容: {scene.test_cameras}")
            if len(scene.test_cameras) > 0:
                try:
                    print(f"第一个测试相机: {scene.test_cameras[0].image_name}")
                except Exception as e:
                    print(f"访问第一个测试相机时出错: {e}")
                    print(f"第一个元素类型: {type(scene.test_cameras[0])}")
    else:
        print("test_cameras属性不存在")
    
    # 尝试调用方法
    print("\n5. 调用相机获取方法...")
    try:
        train_cameras = scene.getTrainCameras()
        print(f"getTrainCameras()返回: {len(train_cameras)} 个相机")
        if len(train_cameras) > 0:
            print(f"第一个训练相机: {train_cameras[0].image_name}")
    except Exception as e:
        print(f"getTrainCameras()出错: {e}")
    
    try:
        test_cameras = scene.getTestCameras()
        print(f"getTestCameras()返回: {len(test_cameras)} 个相机")
        if len(test_cameras) > 0:
            print(f"第一个测试相机: {test_cameras[0].image_name}")
    except Exception as e:
        print(f"getTestCameras()出错: {e}")
    
    print("\n=== 测试完成 ===")

if __name__ == "__main__":
    test_camera_loading()
