# test_am.py
import os
import google.generativeai as genai

def run_gemini_test():
    """
    A complete and correct function to test the Gemini API call.
    """
    # 1. Get the API key from the environment variable
    api_key = os.environ.get("GEMINI_API_KEY")
    if not api_key:
        print("❌ ERROR: Could not find the GEMINI_API_KEY environment variable.")
        return

    print("--- [Test] Attempting a text-only API request...")

    try:
        # 2. Configure the library with your API key
        genai.configure(api_key=api_key)

        # 3. Create the model instance (this is the modern way)
        model = genai.GenerativeModel('gemini-1.5-flash-latest')

        # 4. Send a simple text prompt
        response = model.generate_content(
            "In one short sentence, what is a large language model?",
            request_options={'timeout': 60}
        )

        # 5. Print the successful response
        print("\n✅ SUCCESS! The API call worked.")
        print("Gemini's Response:", response.text.strip())

    except Exception as e:
        # Catch any errors during the API call
        print("\n❌ FAILED! The API call did not succeed.")
        print(f"Error Details: {e}")

if __name__ == '__main__':
    run_gemini_test()