function [L_H, Z_aug, Z_topT, blocks] = buildHypergraph_Star_topT(Z, A, topT, visibleMask)


    [m,n] = size(Z);
    d = size(A,1);

    if nargin < 3 || isempty(topT),      topT = min(5,m); end
    if nargin < 4 || isempty(visibleMask), visibleMask = true(n,1); end
    visibleMask = logical(visibleMask(:));    
    topT = min(topT, m);                       


    if exist('maxk','file')
        [~, idxTop] = maxk(Z, topT, 1);       % topT×n
    else
        [~, idxTop] = sort(Z, 1, 'descend');  
        idxTop = idxTop(1:topT, :);
    end
    T = size(idxTop,1);
    colIdx = repelem(1:n, T);                 % 1×(T*n)
    rowIdx = idxTop(:);                       % (T*n)×1


    sel    = visibleMask(colIdx);             % 1×(T*n) 
    colSel = colIdx(sel).';                   % (S)×1
    rowSel = rowIdx(sel(:));                  % (S)×1

    Z_topT = sparse(m,n);
    lin    = sub2ind([m n], rowSel, colSel);
    Z_topT(lin) = Z(lin);


    noConn = visibleMask & ~any(Z_topT>0,1).';
    if any(noConn)
        [~, bestRow] = max(Z(:, noConn), [], 1);       % 1×S
        fixCols = find(noConn);                        % S×1
        addLin  = sub2ind([m n], bestRow(:), fixCols(:));
        Z_topT(addLin) = Z(addLin);
    end


    Adj = sparse(n+m, n+m);
    [e_idx, i_idx] = find(Z_topT);                    
    wVals = Z(sub2ind([m n], e_idx, i_idx));           
    Adj = Adj + sparse(i_idx, n + e_idx, wVals, n+m, n+m);
    Adj = Adj + sparse(n + e_idx, i_idx, wVals, n+m, n+m); 

    deg  = full(sum(Adj, 2));
    Dinv = spdiags(1 ./ sqrt(max(deg, eps)), 0, n+m, n+m);
    L_H  = speye(n+m) - Dinv * Adj * Dinv;

    % -------- 4) Z_aug = [A*Z, A] （d×(n+m)）--------
    AZ    = A * Z;                               % d×n
    Z_aug = [AZ, A];                             % d×(n+m)

    
    blocks = struct( ...
        'L_dd', L_H(1:n,         1:n), ...
        'L_da', L_H(1:n,         n+1:n+m), ...
        'L_ad', L_H(n+1:n+m,     1:n), ...
        'L_aa', L_H(n+1:n+m,     n+1:n+m) ...
    );


end