function [Fscore, Precision, Recall] = compute_f(Y, predY)


Y     = Y(:);
predY = predY(:);
n = numel(Y);

[~,~,Y1]   = unique(Y,'stable');    
[~,~,P1]   = unique(predY,'stable'); 
k = max(Y1); 
r = max(P1);


C = accumarray([Y1, P1], 1, [k, r]);  


comb2 = @(x) x.*(x-1)/2;


TP = sum(comb2(C(:)));                
FP = sum(comb2(sum(C,1))) - TP;       
FN = sum(comb2(sum(C,2))) - TP;        

Precision = TP / max(TP + FP, eps);
Recall    = TP / max(TP + FN, eps);
Fscore    = 2*Precision*Recall / max(Precision + Recall, eps);
end