function [UU,V,A,W,Z,iter,obj,alpha,ts] = missingalgo_qp(X,Y,d,numanchor,ind)



v  = size(ind,2);               
n  = size(ind,1);                
m  = numanchor; 
numclass = length(unique(Y));
numview  = length(X);
assert(numview==v, '：length(X)=%d, size(ind,2)=%d', numview, v);


S_cell = cell(v,1);
for p = 1:v
    mask = double(ind(:,p)~=0);
    S_cell{p} = spdiags(mask,0,n,n);      
end


cov_p = zeros(1,v);
for p = 1:v, cov_p(p) = nnz(S_cell{p}); end
tot = sum(cov_p);
if tot==0
    beta = ones(1,v)/v;
else
    beta = cov_p/tot;
end



q_vec = 1 - (ind * beta(:));                 % n×1
q_vec = min(max(q_vec,0),1);
%q_vec = ones(1);
Qreg  = spdiags(q_vec,0,n,n);   

%Qreg = eye(n);

gamma = 0.8;
m_vec = exp(-gamma*q_vec);
Msamp = spdiags(m_vec,0,n,n);                
Msqrt = spdiags(sqrt(m_vec), 0, n, n); 
% n×n
%Msamp =eye(n);
%Msqrt = eye(n);

lambda1 = 0.001;
q_mean = mean(q_vec);               
decay = 1 - 0.6 * q_mean;               
lambda1 = lambda1 * max(decay, 0.2);  
lambda2 = 0.01*max(0.2, q_mean);    


Z_topT = sparse(m,n);                       
L_H    = sparse(n+m,n+m);                 
Z_aug  = sparse(d, n+m);                  
B = struct('L_dd',sparse(n,n),'L_da',sparse(n,m), ...
           'L_ad',sparse(m,n),'L_aa',sparse(m,m));   


maxIter = 50;                              
W = cell(numview,1);
for p=1:numview
    di = size(X{p},1);
    W{p} = zeros(di,d);                      % di×d
end
A = zeros(d,m);
Z = zeros(m,n);
alpha=ones(1,v)/v;
AZ = A * Z; 
if m <= n
    Z(:,1:m) = eye(m);
else
    Z(1:n,1:n) = eye(n);                    
end

iter = 0;
obj  = [];
ts   = {};
UU = []; V = [];

flag = 1;      

zinfo = struct('iters', 0, 'relchg', NaN, 'L', NaN);  

topT = min(5, m);                  
visibleMask = any(ind, 2);         


[L_H, Z_aug, Z_topT, B] = buildHypergraph_Star_topT(Z, A, topT, visibleMask);

while flag
    iter = iter + 1;


    AZ = A * Z;                                

    for p = 1:numview
        SpM = S_cell{p} * Msamp;                 % n×n 
        Gp  = X{p} * SpM * AZ';                  % d_p×d
        [Up,~,Vp] = svd(Gp,'econ');
        W{p} = Up * Vp';
    end


    partA = zeros(d,m);
    for p = 1:numview
        SpM = S_cell{p} * Msamp;
        partA = partA + (alpha(p)^2) * (W{p}' * X{p} * SpM * Z');
    end
    [UA,~,VA] = svd(partA,'econ');
    A = UA * VA';
    AZ = A * Z;                                  % A 


    K = lambda1 * B.L_dd + lambda2 * Qreg;       % n×n
    J = -lambda1 * (B.L_da.');                   % m×n
    for p = 1:numview
        SpM = S_cell{p} * Msamp;
        Rp  = W{p}' * X{p};
        K   = K + (alpha(p)^2) * SpM;
        J   = J + (alpha(p)^2) * (A' * Rp * SpM);
    end
    zopts = struct('maxit',50,'tol',1e-3);
    [Z, zinfo] = z_update_fista_simplex(K, J, Z, zopts);
    AZ = A * Z;                                

    R = zeros(numview,1);
    for p = 1:numview
        SpMhalf = S_cell{p} * Msqrt;             % n×n
        E = (W{p}'*X{p} - AZ) * SpMhalf;         % d×n
        R(p) = norm(E,'fro');
    end
    w = 1 ./ max(R, eps);
    alpha = (w / sum(w)).';

    [L_H, Z_aug, ~, B] = buildHypergraph_Star_topT(Z, A, topT, visibleMask);

    term1 = 0;
    for p = 1:numview
        SpMhalf = S_cell{p} * Msqrt;
        E = (W{p}'*X{p} - AZ) * SpMhalf;
        term1 = term1 + (alpha(p)^2) * (norm(E,'fro')^2);
    end
    obj(iter) = term1 + lambda1 * trace(Z_aug * L_H * Z_aug') ...
                        + lambda2 * sum(q_vec(:)' .* sum(Z.^2,1));

    if iter>1 && ( abs(obj(iter-1)-obj(iter))/max(1,obj(iter-1)) < 1e-3        || iter>maxIter || obj(iter)<1e-10 )
        [UU,~,V] = svd(Z','econ');
        UU = UU(:,1:numclass);
        break;
    end
end
         
         

